/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.capability.CapabilityEventDispatchers;
import vswe.stevesfactory.api.capability.IRedstoneEventDispatcher;
import vswe.stevesfactory.api.network.ICable;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.setup.ModBlocks;
import vswe.stevesfactory.utils.NetworkHelper;

public class RedstoneInputTileEntity
extends TileEntity
implements ICable,
IRedstoneEventDispatcher {
    private List<Predicate<IRedstoneEventDispatcher.SignalStatus>> eventHandlers = new ArrayList<Predicate<IRedstoneEventDispatcher.SignalStatus>>();
    private LazyOptional<IRedstoneEventDispatcher> capability = LazyOptional.of(() -> this);
    private IRedstoneEventDispatcher.SignalStatus lastSignalState = new IRedstoneEventDispatcher.SignalStatus();

    public RedstoneInputTileEntity() {
        super((TileEntityType)ModBlocks.redstoneInputTileEntity.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEventDispatchers.REDSTONE_EVENT_DISPATCHER_CAPABILITY) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean hasSignal() {
        assert (this.field_145850_b != null);
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    @Override
    public void subscribe(Consumer<IRedstoneEventDispatcher.SignalStatus> onChange) {
        this.eventHandlers.add(status -> {
            onChange.accept((IRedstoneEventDispatcher.SignalStatus)status);
            return false;
        });
    }

    @Override
    public void subscribe(Predicate<IRedstoneEventDispatcher.SignalStatus> onChange) {
        this.eventHandlers.add(onChange);
    }

    void onRedstoneChange() {
        assert (this.field_145850_b != null);
        IRedstoneEventDispatcher.SignalStatus status = IRedstoneEventDispatcher.SignalStatus.scan(this.field_145850_b, this.field_174879_c);
        if (!this.lastSignalState.equals(status)) {
            this.eventHandlers.removeIf(handler -> handler.test(status));
            this.lastSignalState = status;
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.lastSignalState.read(compound.func_74775_l("LastSignal"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("LastSignal", (INBT)this.lastSignalState.write(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    protected void invalidateCaps() {
        this.capability.invalidate();
        super.invalidateCaps();
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isCable() {
        return (Boolean)Config.COMMON.isRedstoneInputBlockCables.get();
    }

    @Override
    public void addLinksFor(INetworkController controller) {
        NetworkHelper.updateLinksFor(controller, this);
    }
}

