/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.collections;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.PeekingIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class CompositeCollection<E>
extends AbstractCollection<E> {
    private Collection<E>[] collections;

    @SafeVarargs
    public CompositeCollection(Collection<E> ... collections) {
        this.collections = collections;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        if (this.collections.length == 0) {
            return Collections.emptyIterator();
        }
        return new It();
    }

    @Override
    public int size() {
        int s = 0;
        for (Collection<E> window : this.collections) {
            s += window.size();
        }
        return s;
    }

    private class It
    extends AbstractIterator<E>
    implements PeekingIterator<E> {
        private Iterator<E> currentIterator;
        private int currentIndex = 0;

        public It() {
            this.currentIterator = CompositeCollection.this.collections[this.currentIndex].iterator();
        }

        protected E computeNext() {
            while (!this.currentIterator.hasNext()) {
                ++this.currentIndex;
                if (this.currentIndex >= CompositeCollection.this.collections.length) {
                    return this.endOfData();
                }
                this.currentIterator = CompositeCollection.this.collections[this.currentIndex].iterator();
            }
            return this.currentIterator.next();
        }
    }
}

