/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import java.awt.Dimension;
import java.awt.Point;
import vswe.stevesfactory.library.gui.window.IWindow;

public interface IWidget {
    public Point getPosition();

    public int getX();

    public int getY();

    public int getAbsoluteX();

    public int getAbsoluteY();

    default public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    default public void setLocation(int x, int y) {
        this.getPosition().x = x;
        this.getPosition().y = y;
        this.onRelativePositionChanged();
    }

    default public void setX(int x) {
        this.getPosition().x = x;
        this.onRelativePositionChanged();
    }

    default public void setY(int y) {
        this.getPosition().y = y;
        this.onRelativePositionChanged();
    }

    default public void moveX(int dx) {
        this.setX(this.getX() + dx);
    }

    default public void moveY(int dy) {
        this.setY(this.getY() + dy);
    }

    default public void move(int dx, int dy) {
        this.moveX(dx);
        this.moveY(dy);
    }

    public Dimension getDimensions();

    default public void setDimensions(Dimension dimensions) {
        this.setDimensions(dimensions.width, dimensions.height);
    }

    default public void setDimensions(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    default public void setWidth(int width) {
        this.getDimensions().width = width;
    }

    default public void setHeight(int height) {
        this.getDimensions().height = height;
    }

    public int getWidth();

    public int getHeight();

    public void render(int var1, int var2, float var3);

    public IWidget getParentWidget();

    public IWindow getWindow();

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isFocused();

    default public void onFocusChanged(boolean focus) {
    }

    default public void onRemoved() {
    }

    public void setParentWidget(IWidget var1);

    public void onParentPositionChanged();

    public void onRelativePositionChanged();

    public boolean isInside(double var1, double var3);

    public boolean mouseClicked(double var1, double var3, int var5);

    public boolean mouseReleased(double var1, double var3, int var5);

    public boolean mouseDragged(double var1, double var3, int var5, double var6, double var8);

    public boolean mouseScrolled(double var1, double var3, double var5);

    public boolean keyPressed(int var1, int var2, int var3);

    public boolean keyReleased(int var1, int var2, int var3);

    public boolean charTyped(char var1, int var2);

    public void mouseMoved(double var1, double var3);

    public void update(float var1);

    default public boolean doesEffectByTranslation() {
        return false;
    }
}

