/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget.box;

import com.google.common.base.Preconditions;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.StringUtils;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.ScissorTest;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.INamedElement;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.box.ScrollArrow;
import vswe.stevesfactory.utils.Utils;

public class WrappingList<T extends IWidget & INamedElement>
extends AbstractContainer<IWidget>
implements IWidget {
    private int offset;
    private int rows;
    private boolean disabledScroll;
    private Rectangle contentArea = new Rectangle();
    private boolean hasSearchBox;
    private List<T> searchResults;
    private TextField searchBox;
    private ScrollArrow scrollUpArrow;
    private ScrollArrow scrollDownArrow;
    private List<T> contents = new ArrayList<T>();
    private List<IWidget> children;

    public WrappingList(boolean hasSearchBox) {
        this(hasSearchBox ? "" : null);
    }

    public WrappingList(String defaultText) {
        super(0, 0, 80, 80);
        this.contentArea.setSize(this.getDimensions());
        this.hasSearchBox = defaultText != null;
        this.searchBox = this.hasSearchBox ? this.createSearchBox(defaultText) : TextField.DUMMY;
        this.scrollUpArrow = ScrollArrow.up(0, 0);
        this.scrollUpArrow.setParentWidget(this);
        this.scrollDownArrow = ScrollArrow.down(0, 0);
        this.scrollDownArrow.setParentWidget(this);
        this.alignArrows();
        this.children = new AbstractList<IWidget>(){

            @Override
            public IWidget get(int i) {
                switch (i) {
                    case 0: {
                        return WrappingList.this.searchBox;
                    }
                    case 1: {
                        return WrappingList.this.scrollUpArrow;
                    }
                    case 2: {
                        return WrappingList.this.scrollDownArrow;
                    }
                }
                return (IWidget)WrappingList.this.contents.get(i - 3);
            }

            @Override
            public int size() {
                return 3 + WrappingList.this.contents.size();
            }
        };
        this.updateSearch();
    }

    private TextField createSearchBox(String defaultText) {
        TextField t = new TextField(0, 0, this.getSearchBoxWidth(), this.getSearchBoxHeight()){

            @Override
            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257) {
                    WrappingList.this.updateSearch();
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }

            @Override
            public void onFocusChanged(boolean focus) {
                if (!focus) {
                    WrappingList.this.updateSearch();
                }
            }
        };
        t.setParentWidget(this);
        t.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
        t.setEnabled(this.hasSearchBox);
        t.setText(defaultText);
        return t;
    }

    protected List<T> searchItems(String search) {
        ArrayList<IWidget> result = new ArrayList<IWidget>();
        for (IWidget child : this.contents) {
            if (!StringUtils.containsIgnoreCase((CharSequence)((INamedElement)((Object)child)).getName(), (CharSequence)search)) continue;
            result.add(child);
        }
        return result;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        int y2;
        int x2;
        int y1;
        if (!this.isInside(mouseX, mouseY) || !this.isEnabled()) {
            return false;
        }
        int x1 = this.getAbsoluteX() + this.getScrollingSectionY();
        if (!Utils.isInside((int)mouseX, (int)mouseY, x1, y1 = this.getAbsoluteY() + this.getScrollingSectionY(), x2 = x1 + this.getScrollingSectionWidth(), y2 = y1 + this.getScrollingSectionHeight())) {
            return false;
        }
        int oldOffset = this.offset;
        this.scroll((int)scroll * -5);
        return oldOffset != this.offset;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        if (this.searchBox.getText().length() > 0 || this.searchResults.size() > 0) {
            String status = I18n.func_135052_a((String)"gui.sfm.WrappingList.SearchStatus", (Object[])new Object[]{this.searchResults.size()});
            RenderingHelper.drawTextCenteredVertically(status, this.searchBox.getAbsoluteXRight() + 4, this.searchBox.getAbsoluteY(), this.searchBox.getAbsoluteYBottom(), 8, 0x404040);
        }
        this.searchBox.render(mouseX, mouseY, particleTicks);
        this.scrollUpArrow.render(mouseX, mouseY, particleTicks);
        this.scrollDownArrow.render(mouseX, mouseY, particleTicks);
        int left = this.getAbsoluteX() + this.getScrollingSectionX();
        int top = this.getAbsoluteY() + this.getScrollingSectionY();
        ScissorTest test = ScissorTest.scaled(left, top, this.contentArea.width, this.contentArea.height);
        int sTop = this.getScrollingSectionY();
        int sBottom = sTop + this.contentArea.height;
        for (IWidget child : this.searchResults) {
            int cy = child.getY();
            if (cy + child.getHeight() <= sTop || cy >= sBottom) continue;
            child.render(mouseX, mouseY, particleTicks);
        }
        test.destroy();
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    public void scroll(int change) {
        if (this.disabledScroll) {
            return;
        }
        this.offset += change;
        int min = 0;
        int contentHeight = this.rows * this.getItemSizeWithMargin();
        int visibleHeight = this.getVisibleRows() * this.getItemSizeWithMargin();
        int max = Utils.lowerBound(contentHeight - visibleHeight, 0);
        this.scrollUpArrow.setEnabled(true);
        this.scrollDownArrow.setEnabled(true);
        if (max == 0) {
            this.offset = 0;
            this.scrollUpArrow.setEnabled(false);
            this.scrollDownArrow.setEnabled(false);
        } else if (this.offset < min) {
            this.offset = min;
            this.scrollUpArrow.setEnabled(false);
        } else if (this.offset > max) {
            this.offset = max;
            this.scrollDownArrow.setEnabled(false);
        }
        this.reflow();
    }

    public void scrollUp(int change) {
        this.scroll(-change);
    }

    public void scrollUpUnit() {
        this.scroll(-this.getScrollSpeed());
    }

    public void scrollDown(int change) {
        this.scroll(change);
    }

    public void scrollDownUnit() {
        this.scroll(this.getScrollSpeed());
    }

    @Override
    public List<IWidget> getChildren() {
        return this.children;
    }

    public List<T> getContents() {
        return this.contents;
    }

    @Override
    public WrappingList<T> addChildren(IWidget widget) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WrappingList<T> addChildren(Collection<IWidget> widgets) {
        throw new UnsupportedOperationException();
    }

    public WrappingList<T> addElement(T widget) {
        Preconditions.checkArgument((widget.getWidth() == this.getItemSize() && widget.getHeight() == this.getItemSize() ? 1 : 0) != 0);
        this.contents.add(widget);
        this.reflow();
        return this;
    }

    @Override
    public void reflow() {
        int initialX;
        int x = initialX = this.getScrollingSectionX();
        int y = this.getFirstRowY();
        this.rows = 1;
        for (IWidget child : this.searchResults) {
            child.setLocation(x, y);
            if ((x += this.getItemSizeWithMargin()) <= this.contentArea.width) continue;
            x = initialX;
            y += this.getItemSizeWithMargin();
            ++this.rows;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.searchBox.setEnabled(enabled);
        this.scrollUpArrow.setEnabled(enabled);
        this.scrollDownArrow.setEnabled(enabled);
    }

    public void updateScrolling() {
        boolean canScroll;
        boolean bl = canScroll = this.contents.size() > this.getItemsPerRow() * this.getVisibleRows();
        if (!canScroll) {
            this.offset = 0;
        }
        this.scrollUpArrow.setEnabled(canScroll);
        this.scrollDownArrow.setEnabled(canScroll);
    }

    public void updateSearch() {
        if (this.hasSearchBox()) {
            this.searchResults = this.searchBox.getText().isEmpty() ? this.contents : this.searchItems(this.searchBox.getText());
            this.reflow();
        } else {
            this.searchResults = this.contents;
        }
        this.updateScrolling();
    }

    public void setSearchTarget(String s) {
        this.searchBox.setText(s);
        this.updateSearch();
    }

    public String getSearchTarget() {
        return this.searchBox.getText();
    }

    public void setDisabledScroll(boolean disabledScroll) {
        this.disabledScroll = disabledScroll;
    }

    public boolean hasSearchBox() {
        return this.hasSearchBox;
    }

    public Rectangle getContentArea() {
        return this.contentArea;
    }

    public int getScrollingSectionX() {
        return this.contentArea.x;
    }

    public int getScrollingSectionY() {
        return this.contentArea.y;
    }

    public int getScrollingSectionWidth() {
        return this.contentArea.width;
    }

    public int getScrollingSectionHeight() {
        return this.contentArea.height;
    }

    public int getItemsPerRow() {
        return (int)Math.ceil((double)this.contentArea.width / (double)this.getItemSizeWithMargin());
    }

    public void setItemsPerRow(int itemsPerRow) {
        this.contentArea.width = itemsPerRow * this.getItemSizeWithMargin() - this.getMargin();
    }

    public int getVisibleRows() {
        return (int)Math.ceil((double)this.contentArea.height / (double)this.getItemSizeWithMargin());
    }

    public void setVisibleRows(int visibleRows) {
        this.contentArea.height = visibleRows * this.getItemSizeWithMargin() - this.getMargin();
    }

    private int getFirstRowY() {
        return this.getScrollingSectionY() - this.offset;
    }

    public int getMargin() {
        return 4;
    }

    public int getItemSize() {
        return 16;
    }

    public int getItemSizeWithMargin() {
        return this.getItemSize() + this.getMargin();
    }

    public int getScrollSpeed() {
        return 5;
    }

    public int getSearchBoxWidth() {
        return 64;
    }

    public int getSearchBoxHeight() {
        return 12;
    }

    public ScrollArrow getScrollUpArrow() {
        return this.scrollUpArrow;
    }

    public ScrollArrow getScrollDownArrow() {
        return this.scrollDownArrow;
    }

    public TextField getSearchBox() {
        return this.searchBox;
    }

    public void placeArrows(int x, int y) {
        this.scrollUpArrow.setLocation(x, y);
        this.alignArrows();
    }

    public void alignArrows() {
        this.scrollDownArrow.setLocation(this.scrollUpArrow.getX(), this.scrollUpArrow.getY() + this.scrollUpArrow.getHeight() + this.getMargin());
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
    }
}

