/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.api.capability.CapabilityEventDispatchers;
import vswe.stevesfactory.api.capability.IBUDEventDispatcher;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.ITrigger;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.execution.ProcedureExecutor;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.setup.ModProcedures;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.utils.IOHelper;

public class BUDTriggerProcedure
extends AbstractProcedure
implements ITrigger,
IInventoryTarget {
    public static final int WATCHING = 0;
    private List<BlockPos> watchingSources = new ArrayList<BlockPos>();
    private boolean dirty = true;

    public BUDTriggerProcedure() {
        super(ModProcedures.budTrigger, 0, 1);
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
    }

    @Override
    public void tick(INetworkController controller) {
        if (!this.dirty && this.isValid()) {
            return;
        }
        World world = controller.getControllerWorld();
        for (BlockPos watching : this.watchingSources) {
            LazyOptional cap;
            TileEntity tile = world.func_175625_s(watching);
            if (tile == null || !(cap = tile.getCapability(CapabilityEventDispatchers.BUD_EVENT_DISPATCHER_CAPABILITY)).isPresent()) continue;
            IBUDEventDispatcher dispatcher = (IBUDEventDispatcher)cap.orElseThrow(RuntimeException::new);
            dispatcher.subscribe(pos -> {
                if (!this.isValid()) {
                    return true;
                }
                Connection connection = this.successors()[0];
                if (connection != null) {
                    new ProcedureExecutor(controller, world).start(connection.getDestination());
                }
                return false;
            });
        }
        this.dirty = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<BUDTriggerProcedure> createFlowComponent() {
        FlowComponent<BUDTriggerProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.BUDTrigger.Watches", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.BUDTrigger.NoWatches", (Object[])new Object[0]), CapabilityEventDispatchers.BUD_EVENT_DISPATCHER_CAPABILITY));
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("Watching", (INBT)IOHelper.writeBlockPoses(this.watchingSources));
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.watchingSources = IOHelper.readBlockPoses(tag.func_150295_c("Watching", 10), new ArrayList());
        this.markDirty();
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        return this.watchingSources;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }
}

