/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.item.CraftingBufferElement;
import vswe.stevesfactory.logic.item.RecipeInfo;
import vswe.stevesfactory.logic.procedure.ICraftingGrid;
import vswe.stevesfactory.setup.ModProcedures;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.CraftingRecipeMenu;
import vswe.stevesfactory.utils.IOHelper;

public class CraftingProcedure
extends AbstractProcedure
implements ICraftingGrid {
    private CraftingInventory inventory = CraftingProcedure.createCraftingInventory();
    private transient RecipeInfo info;

    public CraftingProcedure() {
        super(ModProcedures.crafting);
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
        this.updateRecipe(context);
        if (this.hasError()) {
            return;
        }
        CraftingBufferElement buffer = new CraftingBufferElement(context);
        buffer.setRecipe(this.info);
        context.getItemBuffers(CraftingBufferElement.class).put(buffer.getStack().func_77973_b(), buffer);
    }

    private void updateRecipe(IExecutionContext context) {
        if (this.info == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            Preconditions.checkState((server != null ? 1 : 0) != 0, (Object)"Illegal to execute procedure on client side");
            Optional lookup = server.func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.inventory, context.getControllerWorld());
            this.info = lookup.map(RecipeInfo::new).orElse(null);
        }
    }

    public boolean hasError() {
        return this.info == null || this.info.getRecipe().func_192399_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<CraftingProcedure> createFlowComponent() {
        FlowComponent<CraftingProcedure> f = FlowComponent.of(this);
        f.addMenu(new CraftingRecipeMenu());
        return f;
    }

    @Override
    public CraftingInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ItemStack getIngredient(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    @Override
    public void setIngredient(int slot, ItemStack ingredient) {
        this.inventory.func_70299_a(slot, ingredient);
        this.info = null;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("RecipeInv", (INBT)IOHelper.writeInventory((IInventory)this.inventory));
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        IOHelper.readInventory(tag.func_150295_c("RecipeInv", 10), this.inventory);
    }

    private static CraftingInventory createCraftingInventory() {
        return new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        }, 3, 3);
    }
}

