/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.fluid.SingleFluidBufferElement;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.setup.ModProcedures;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.DirectionSelectionMenu;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.NetworkHelper;

public class FluidTransferProcedure
extends AbstractProcedure
implements IInventoryTarget,
IDirectionTarget {
    public static final int SOURCE_TANKS = 0;
    public static final int DESTINATION_TANKS = 1;
    public static final int FILTER = 0;
    private List<BlockPos> sourceTanks = new ArrayList<BlockPos>();
    private Set<Direction> sourceDirections = EnumSet.noneOf(Direction.class);
    private List<BlockPos> destinationTanks = new ArrayList<BlockPos>();
    private Set<Direction> destinationDirections = EnumSet.noneOf(Direction.class);
    private transient List<LazyOptional<IFluidHandler>> cachedSourceCaps = new ArrayList<LazyOptional<IFluidHandler>>();
    private transient List<LazyOptional<IFluidHandler>> cachedDestinationCaps = new ArrayList<LazyOptional<IFluidHandler>>();
    private transient boolean dirty = false;

    public FluidTransferProcedure() {
        super(ModProcedures.fluidTransfer);
    }

    @Override
    public void execute(IExecutionContext context) {
        IFluidHandler handler;
        this.pushFrame(context, 0);
        if (this.hasError()) {
            return;
        }
        this.cacheCaps(context);
        ArrayList<SingleFluidBufferElement> buffers = new ArrayList<SingleFluidBufferElement>();
        for (LazyOptional<IFluidHandler> cap : this.cachedSourceCaps) {
            if (!cap.isPresent()) continue;
            handler = (IFluidHandler)cap.orElseThrow(RuntimeException::new);
            FluidStack stack = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            buffers.add(new SingleFluidBufferElement(stack, handler));
        }
        for (LazyOptional<IFluidHandler> cap : this.cachedDestinationCaps) {
            if (!cap.isPresent()) continue;
            handler = (IFluidHandler)cap.orElseThrow(RuntimeException::new);
            for (SingleFluidBufferElement buffer : buffers) {
                FluidStack source = buffer.stack;
                if (source.isEmpty()) continue;
                int consumed = handler.fill(source, IFluidHandler.FluidAction.EXECUTE);
                buffer.used += consumed;
            }
        }
        for (SingleFluidBufferElement buffer : buffers) {
            if (buffer.used <= 0) continue;
            buffer.handler.drain(buffer.used, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean hasError() {
        return this.sourceTanks.isEmpty() || this.sourceDirections.isEmpty() || this.destinationTanks.isEmpty() || this.destinationDirections.isEmpty();
    }

    private void cacheCaps(IExecutionContext context) {
        if (!this.dirty) {
            return;
        }
        Set<BlockPos> linkedInventories = context.getController().getLinkedInventories(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        this.cachedSourceCaps.clear();
        this.cachedDestinationCaps.clear();
        NetworkHelper.cacheDirectionalCaps(context, linkedInventories, this.cachedSourceCaps, this.sourceTanks, this.sourceDirections, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, __ -> this.markDirty());
        NetworkHelper.cacheDirectionalCaps(context, linkedInventories, this.cachedDestinationCaps, this.destinationTanks, this.destinationDirections, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, __ -> this.markDirty());
        this.dirty = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<FluidTransferProcedure> createFlowComponent() {
        FlowComponent<FluidTransferProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.TankSelection.Source", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.FluidTransfer.NoSrcTank", (Object[])new Object[0]), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
        f.addMenu(new InventorySelectionMenu(1, I18n.func_135052_a((String)"menu.sfm.TankSelection.Destination", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.FluidTransfer.NoSrcTarget", (Object[])new Object[0]), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
        f.addMenu(new DirectionSelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.TargetSides.Source", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.FluidTransfer.NoDestTank", (Object[])new Object[0])));
        f.addMenu(new DirectionSelectionMenu(1, I18n.func_135052_a((String)"menu.sfm.TargetSides.Destination", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.FluidTransfer.NoDestTarget", (Object[])new Object[0])));
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("SourcePoses", (INBT)IOHelper.writeBlockPoses(this.sourceTanks));
        tag.func_74783_a("SourceDirections", IOHelper.direction2Index(this.sourceDirections));
        tag.func_218657_a("TargetPoses", (INBT)IOHelper.writeBlockPoses(this.destinationTanks));
        tag.func_74783_a("TargetDirections", IOHelper.direction2Index(this.destinationDirections));
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.sourceTanks = IOHelper.readBlockPoses(tag.func_150295_c("SourcePoses", 10), new ArrayList());
        this.sourceDirections = IOHelper.index2DirectionFill(tag.func_74759_k("SourceDirections"), EnumSet.noneOf(Direction.class));
        this.destinationTanks = IOHelper.readBlockPoses(tag.func_150295_c("TargetPoses", 10), new ArrayList());
        this.destinationDirections = IOHelper.index2DirectionFill(tag.func_74759_k("TargetDirections"), EnumSet.noneOf(Direction.class));
        this.markDirty();
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        switch (id) {
            default: {
                return this.sourceTanks;
            }
            case 1: 
        }
        return this.destinationTanks;
    }

    @Override
    public Set<Direction> getDirections(int id) {
        switch (id) {
            default: {
                return this.sourceDirections;
            }
            case 1: 
        }
        return this.destinationDirections;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }
}

