/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.ITrigger;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.execution.ProcedureExecutor;
import vswe.stevesfactory.setup.ModProcedures;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.IntervalMenu;

public class IntervalTriggerProcedure
extends AbstractProcedure
implements ITrigger {
    public int interval = 20;
    private transient int tickCounter = 0;

    public IntervalTriggerProcedure() {
        super(ModProcedures.intervalTrigger, 0, 1);
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
    }

    @Override
    public void tick(INetworkController controller) {
        if (this.tickCounter >= this.interval) {
            new ProcedureExecutor(controller, controller.getControllerWorld()).start(this);
            this.tickCounter = 0;
        } else {
            ++this.tickCounter;
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<IntervalTriggerProcedure> createFlowComponent() {
        FlowComponent<IntervalTriggerProcedure> f = FlowComponent.of(this);
        f.addMenu(new IntervalMenu());
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_74768_a("Interval", this.interval);
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.interval = tag.func_74762_e("Interval");
    }
}

