/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.FilterType;
import vswe.stevesfactory.logic.item.IItemFilter;
import vswe.stevesfactory.logic.item.ItemTraitsFilter;
import vswe.stevesfactory.logic.item.SingleItemBufferElement;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.logic.procedure.IItemFilterTarget;
import vswe.stevesfactory.setup.ModProcedures;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.PropertyManager;
import vswe.stevesfactory.ui.manager.menu.DirectionSelectionMenu;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.NetworkHelper;

public class ItemTransferProcedure
extends AbstractProcedure
implements IInventoryTarget,
IDirectionTarget,
IItemFilterTarget {
    public static final int SOURCE_INVENTORIES = 0;
    public static final int DESTINATION_INVENTORIES = 1;
    public static final int FILTER = 0;
    private List<BlockPos> sourceInventories = new ArrayList<BlockPos>();
    private Set<Direction> sourceDirections = EnumSet.noneOf(Direction.class);
    private List<BlockPos> destinationInventories = new ArrayList<BlockPos>();
    private Set<Direction> destinationDirections = EnumSet.noneOf(Direction.class);
    private IItemFilter filter = new ItemTraitsFilter();
    private List<LazyOptional<IItemHandler>> cachedSourceCaps = new ArrayList<LazyOptional<IItemHandler>>();
    private List<LazyOptional<IItemHandler>> cachedDestinationCaps = new ArrayList<LazyOptional<IItemHandler>>();
    private boolean dirty = false;

    public ItemTransferProcedure() {
        super(ModProcedures.itemTransfer);
        this.filter.setType(FilterType.BLACKLIST);
    }

    @Override
    public void execute(IExecutionContext context) {
        IItemHandler handler;
        this.pushFrame(context, 0);
        if (this.hasError()) {
            return;
        }
        this.cacheCaps(context);
        ArrayList items = new ArrayList();
        HashSet<IItemHandler> visited = new HashSet<IItemHandler>();
        for (LazyOptional<IItemHandler> cap : this.cachedSourceCaps) {
            if (!cap.isPresent() || visited.contains(handler = (IItemHandler)cap.orElseThrow(RuntimeException::new))) continue;
            visited.add(handler);
            this.filter.extractFromInventory(handler, (stack, slot) -> items.add(new SingleItemBufferElement((ItemStack)stack, handler, (int)slot)));
        }
        for (LazyOptional<IItemHandler> cap : this.cachedDestinationCaps) {
            if (!cap.isPresent()) continue;
            handler = (IItemHandler)cap.orElseThrow(RuntimeException::new);
            for (SingleItemBufferElement buffer : items) {
                ItemStack source = buffer.stack;
                if (source.func_190926_b()) continue;
                int sourceStackSize = source.func_190916_E();
                ItemStack untaken = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)source, (boolean)false);
                buffer.used += sourceStackSize - untaken.func_190916_E();
                buffer.stack = untaken;
            }
        }
        for (SingleItemBufferElement buffer : items) {
            if (buffer.used <= 0) continue;
            buffer.inventory.extractItem(buffer.slot, buffer.used, false);
        }
    }

    public boolean hasError() {
        return this.sourceInventories.isEmpty() || this.sourceDirections.isEmpty() || this.destinationInventories.isEmpty() || this.destinationDirections.isEmpty();
    }

    private void cacheCaps(IExecutionContext context) {
        if (!this.dirty) {
            return;
        }
        Set<BlockPos> linkedInventories = context.getController().getLinkedInventories(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        this.cachedSourceCaps.clear();
        this.cachedDestinationCaps.clear();
        NetworkHelper.cacheDirectionalCaps(context, linkedInventories, this.cachedSourceCaps, this.sourceInventories, this.sourceDirections, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, __ -> this.markDirty());
        NetworkHelper.cacheDirectionalCaps(context, linkedInventories, this.cachedDestinationCaps, this.destinationInventories, this.destinationDirections, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, __ -> this.markDirty());
        this.dirty = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<ItemTransferProcedure> createFlowComponent() {
        FlowComponent<ItemTransferProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.InventorySelection.Source", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.ItemTransfer.NoSrcInv", (Object[])new Object[0]), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
        f.addMenu(new InventorySelectionMenu(1, I18n.func_135052_a((String)"menu.sfm.InventorySelection.Destination", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.ItemTransfer.NoSrcTarget", (Object[])new Object[0]), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
        f.addMenu(new DirectionSelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.TargetSides.Source", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.ItemTransfer.NoDestInv", (Object[])new Object[0])));
        f.addMenu(new DirectionSelectionMenu(1, I18n.func_135052_a((String)"menu.sfm.TargetSides.Destination", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.ItemTransfer.NoDestTarget", (Object[])new Object[0])));
        PropertyManager.createFilterMenu(this, f, 0);
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("SourcePoses", (INBT)IOHelper.writeBlockPoses(this.sourceInventories));
        tag.func_74783_a("SourceDirections", IOHelper.direction2Index(this.sourceDirections));
        tag.func_218657_a("TargetPoses", (INBT)IOHelper.writeBlockPoses(this.destinationInventories));
        tag.func_74783_a("TargetDirections", IOHelper.direction2Index(this.destinationDirections));
        tag.func_218657_a("Filter", (INBT)IOHelper.writeItemFilter(this.filter));
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.sourceInventories = IOHelper.readBlockPoses(tag.func_150295_c("SourcePoses", 10), new ArrayList());
        this.sourceDirections = IOHelper.index2DirectionFill(tag.func_74759_k("SourceDirections"), EnumSet.noneOf(Direction.class));
        this.destinationInventories = IOHelper.readBlockPoses(tag.func_150295_c("TargetPoses", 10), new ArrayList());
        this.destinationDirections = IOHelper.index2DirectionFill(tag.func_74759_k("TargetDirections"), EnumSet.noneOf(Direction.class));
        this.filter = IOHelper.readItemFilter(tag.func_74775_l("Filter"));
        this.markDirty();
    }

    @Override
    public IItemFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IItemFilter filter) {
        this.filter = filter;
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        switch (id) {
            default: {
                return this.sourceInventories;
            }
            case 1: 
        }
        return this.destinationInventories;
    }

    @Override
    public Set<Direction> getDirections(int id) {
        switch (id) {
            default: {
                return this.sourceDirections;
            }
            case 1: 
        }
        return this.destinationDirections;
    }

    @Override
    public IItemFilter getFilter(int id) {
        return this.filter;
    }

    @Override
    public void setFilter(int filterID, IItemFilter filter) {
        if (filterID == 0) {
            this.filter = filter;
        }
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }
}

