/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.api.capability.CapabilityRedstone;
import vswe.stevesfactory.api.capability.IRedstoneHandler;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.setup.ModProcedures;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.EmitterTypeMenu;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.ui.manager.menu.RedstoneSidesMenu;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.NetworkHelper;

public class RedstoneEmitterProcedure
extends AbstractProcedure
implements IInventoryTarget,
IDirectionTarget {
    public static final int EMITTERS = 0;
    public static final int SIDES = 0;
    private List<BlockPos> emitters = new ArrayList<BlockPos>();
    private Set<Direction> directions = EnumSet.allOf(Direction.class);
    private IRedstoneHandler.Type signalType = IRedstoneHandler.Type.WEAK;
    private OperationType operationType = OperationType.FIXED;
    private int value = 15;
    private transient List<LazyOptional<IRedstoneHandler>> cachedRedstoneCaps = new ArrayList<LazyOptional<IRedstoneHandler>>();
    private transient boolean dirty = false;

    public RedstoneEmitterProcedure() {
        super(ModProcedures.redstoneEmitter);
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
        if (this.hasError()) {
            return;
        }
        this.updateCache(context);
        for (LazyOptional<IRedstoneHandler> cap : this.cachedRedstoneCaps) {
            cap.ifPresent(redstone -> {
                redstone.setType(this.signalType);
                switch (this.operationType) {
                    case FIXED: {
                        redstone.setSignal(this.value);
                        break;
                    }
                    case TOGGLE: {
                        int signal = redstone.getSignal();
                        redstone.setSignal(signal > 0 ? 0 : this.value);
                        break;
                    }
                    case FORWARD: {
                        redstone.setSignal((redstone.getSignal() + this.value) % 16);
                        break;
                    }
                    case BACKWARD: {
                        int signal = redstone.getSignal() - this.value;
                        redstone.setSignal(signal < 0 ? signal + 16 : signal);
                        break;
                    }
                    case MIN: {
                        redstone.setSignal(Math.min(redstone.getSignal(), this.value));
                        break;
                    }
                    case MAX: {
                        redstone.setSignal(Math.max(redstone.getSignal(), this.value));
                        break;
                    }
                    case INCREASE: {
                        redstone.setSignal(redstone.getSignal() + this.value);
                        break;
                    }
                    case DECREASE: {
                        redstone.setSignal(redstone.getSignal() - this.value);
                    }
                }
            });
        }
    }

    public boolean hasError() {
        return this.emitters.isEmpty() || this.directions.isEmpty();
    }

    private void updateCache(IExecutionContext context) {
        if (!this.dirty) {
            return;
        }
        this.cachedRedstoneCaps.clear();
        NetworkHelper.cacheDirectionalCaps(context, this.cachedRedstoneCaps, this.emitters, this.directions, CapabilityRedstone.REDSTONE_CAPABILITY, __ -> this.markDirty());
        this.dirty = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<RedstoneEmitterProcedure> createFlowComponent() {
        FlowComponent<RedstoneEmitterProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.RedstoneEmitter.Emitters", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.RedstoneEmitter.NoEmitters", (Object[])new Object[0]), CapabilityRedstone.REDSTONE_CAPABILITY));
        f.addMenu(new RedstoneSidesMenu(0, () -> this.signalType == IRedstoneHandler.Type.WEAK, () -> {
            this.signalType = IRedstoneHandler.Type.WEAK;
        }, I18n.func_135052_a((String)"menu.sfm.WeakRedstoneSignal", (Object[])new Object[0]), () -> this.signalType == IRedstoneHandler.Type.STRONG, () -> {
            this.signalType = IRedstoneHandler.Type.STRONG;
        }, I18n.func_135052_a((String)"menu.sfm.StrongRedstoneSignal", (Object[])new Object[0]), I18n.func_135052_a((String)"menu.sfm.RedstoneEmitter.Sides", (Object[])new Object[0]), I18n.func_135052_a((String)"menu.sfm.RedstoneEmitter.Sides.Info", (Object[])new Object[0])));
        f.addMenu(new EmitterTypeMenu());
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("Emitters", (INBT)IOHelper.writeBlockPoses(this.emitters));
        tag.func_74783_a("Directions", IOHelper.direction2Index(this.directions));
        tag.func_74768_a("OperationType", this.operationType.ordinal());
        tag.func_74768_a("SignalType", this.signalType.ordinal());
        tag.func_74768_a("Value", this.value);
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.emitters = IOHelper.readBlockPoses(tag.func_150295_c("Emitters", 10), new ArrayList());
        this.directions = IOHelper.index2DirectionFill(tag.func_74759_k("Directions"), EnumSet.noneOf(Direction.class));
        this.operationType = OperationType.VALUES[tag.func_74762_e("OperationType")];
        this.signalType = IRedstoneHandler.Type.VALUES[tag.func_74762_e("SignalType")];
        this.value = tag.func_74762_e("Value");
        this.markDirty();
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        return this.emitters;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    @Override
    public Set<Direction> getDirections(int id) {
        return this.directions;
    }

    public static enum OperationType {
        FIXED("Fixed"),
        TOGGLE("Toggle"),
        FORWARD("Forward"),
        BACKWARD("Backward"),
        MIN("Min"),
        MAX("Max"),
        INCREASE("Increase"),
        DECREASE("Decrease");

        public final String nameKey;
        public static final OperationType[] VALUES;

        private OperationType(String nameKey) {
            this.nameKey = "menu.sfm.RedstoneEmitter.Type." + nameKey;
        }

        static {
            VALUES = OperationType.values();
        }
    }
}

