/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.network;

import com.google.common.base.Preconditions;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import vswe.stevesfactory.network.PacketReloadComponentGroups;
import vswe.stevesfactory.network.PacketSyncIntakeData;
import vswe.stevesfactory.network.PacketSyncProcedureGraph;
import vswe.stevesfactory.network.PacketSyncProcedureGroups;

public final class NetworkHandler {
    public static final String PROTOCOL_VERSION = Integer.toString(0);
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("sfm", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int nextID = 0;

    public static void register() {
        NetworkHandler.registerMessage(PacketSyncProcedureGraph.class, PacketSyncProcedureGraph::encode, PacketSyncProcedureGraph::decode, PacketSyncProcedureGraph::handle);
        NetworkHandler.registerMessage(PacketSyncProcedureGroups.class, PacketSyncProcedureGroups::encode, PacketSyncProcedureGroups::decode, PacketSyncProcedureGroups::handle);
        NetworkHandler.registerMessage(PacketSyncIntakeData.class, PacketSyncIntakeData::encode, PacketSyncIntakeData::decode, PacketSyncIntakeData::handle);
        NetworkHandler.registerMessage(PacketReloadComponentGroups.class, PacketReloadComponentGroups::encode, PacketReloadComponentGroups::decode, PacketReloadComponentGroups::handle);
    }

    public static void sendTo(ServerPlayerEntity player, Object msg) {
        if (!(player instanceof FakePlayer)) {
            CHANNEL.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler) {
        Preconditions.checkState((nextID < 255 ? 1 : 0) != 0, (Object)"Too many messages!");
        CHANNEL.registerMessage(nextID, messageType, encoder, decoder, handler);
        ++nextID;
    }
}

