/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.network;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import vswe.stevesfactory.network.NetworkHandler;
import vswe.stevesfactory.ui.manager.selection.ComponentGroup;

public final class PacketReloadComponentGroups {
    private boolean reset;

    public static void reload(ServerPlayerEntity client) {
        NetworkHandler.sendTo(client, new PacketReloadComponentGroups(false));
    }

    public static void reset(ServerPlayerEntity client) {
        NetworkHandler.sendTo(client, new PacketReloadComponentGroups(true));
    }

    public static void encode(PacketReloadComponentGroups msg, PacketBuffer buf) {
        buf.writeBoolean(msg.reset);
    }

    public static PacketReloadComponentGroups decode(PacketBuffer buf) {
        boolean reset = buf.readBoolean();
        return new PacketReloadComponentGroups(reset);
    }

    public static void handle(PacketReloadComponentGroups msg, Supplier<NetworkEvent.Context> ctx) {
        Preconditions.checkState((ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT ? 1 : 0) != 0);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketReloadComponentGroups.lambda$null$0(msg, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(PacketReloadComponentGroups msg, Supplier<NetworkEvent.Context> ctx) {
        ComponentGroup.reload(msg.reset);
        ctx.get().enqueueWork(() -> Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("message.sfm.reload.componentGroups.success", new Object[0])));
        ctx.get().setPacketHandled(true);
    }

    public PacketReloadComponentGroups(boolean reset) {
        this.reset = reset;
    }

    private static /* synthetic */ void lambda$null$0(PacketReloadComponentGroups msg, Supplier ctx) {
        PacketReloadComponentGroups.handleClient(msg, ctx);
    }
}

