/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.network;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.blocks.FactoryManagerTileEntity;

public class PacketSyncProcedureGroups {
    private DimensionType dimension;
    private BlockPos pos;
    private Collection<String> groups;

    public static void encode(PacketSyncProcedureGroups msg, PacketBuffer buf) {
        buf.func_192572_a(Objects.requireNonNull(msg.dimension.getRegistryName()));
        buf.func_179255_a(msg.pos);
        buf.func_150787_b(msg.groups.size());
        for (String group : msg.groups) {
            buf.func_180714_a(group);
        }
    }

    public static PacketSyncProcedureGroups decode(PacketBuffer buf) {
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)buf.func_192575_l());
        BlockPos pos = buf.func_179259_c();
        int size = buf.func_150792_a();
        ArrayList<String> groups = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            groups.add(buf.func_218666_n());
        }
        return new PacketSyncProcedureGroups(dimension, pos, groups);
    }

    public static void handle(PacketSyncProcedureGroups msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Preconditions.checkState((sender != null ? 1 : 0) != 0, (Object)"Invalid usage of a client to server packet");
            World world = sender.field_70170_p;
            TileEntity tile = world.func_175625_s(msg.pos);
            if (tile instanceof FactoryManagerTileEntity) {
                FactoryManagerTileEntity manager = (FactoryManagerTileEntity)tile;
                manager.getGroups().clear();
                manager.getGroups().addAll(msg.groups);
            } else {
                StevesFactoryManager.logger.error("Received packet with invalid controller position {}!", (Object)msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public PacketSyncProcedureGroups(DimensionType dimension, BlockPos pos, Collection<String> groups) {
        this.dimension = dimension;
        this.pos = pos;
        this.groups = groups;
    }
}

