/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager;

import java.awt.Dimension;
import java.util.List;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;

public abstract class DynamicWidthWidget<T extends IWidget>
extends AbstractContainer<T>
implements IWidget {
    private WidthOccupierType widthOccupier;

    /*
     * WARNING - void declaration
     */
    public static List<DynamicWidthWidget<?>> reflowDynamicWidth(Dimension bounds, List<DynamicWidthWidget<?>> widgets) {
        int amountMaxWidth = 0;
        for (DynamicWidthWidget<?> widget : widgets) {
            if (!BoxSizing.shouldIncludeWidget(widget)) continue;
            switch (widget.getWidthOccupier()) {
                case MIN_WIDTH: {
                    break;
                }
                case MAX_WIDTH: {
                    ++amountMaxWidth;
                }
            }
        }
        int usable = bounds.width;
        for (DynamicWidthWidget dynamicWidthWidget : widgets) {
            if (!BoxSizing.shouldIncludeWidget(dynamicWidthWidget) || dynamicWidthWidget.getWidthOccupier() != WidthOccupierType.MIN_WIDTH) continue;
            usable -= dynamicWidthWidget.getWidth();
        }
        int unit = usable / amountMaxWidth;
        boolean bl = false;
        for (DynamicWidthWidget<?> widget : widgets) {
            void var5_9;
            if (!BoxSizing.shouldIncludeWidget(widget)) continue;
            if (widget.getWidthOccupier() == WidthOccupierType.MAX_WIDTH) {
                widget.setWidth(unit);
            }
            widget.setX((int)var5_9);
            var5_9 += widget.getWidth();
        }
        for (DynamicWidthWidget<?> widget : widgets) {
            widget.onAfterReflow();
        }
        return widgets;
    }

    public DynamicWidthWidget(WidthOccupierType widthOccupier) {
        super(0, 0, 0, 0);
        this.widthOccupier = widthOccupier;
    }

    @Override
    public void onParentPositionChanged() {
        super.onParentPositionChanged();
        this.setHeight(this.getParentHeight());
    }

    public WidthOccupierType getWidthOccupier() {
        return this.widthOccupier;
    }

    protected void onAfterReflow() {
    }

    public static enum WidthOccupierType {
        MIN_WIDTH,
        MAX_WIDTH;

    }
}

