/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.StrictTableLayout;
import vswe.stevesfactory.library.gui.screen.DisplayListCaches;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.window.AbstractWindow;
import vswe.stevesfactory.ui.manager.DynamicWidthWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerContainer;
import vswe.stevesfactory.ui.manager.editor.ConnectionsPanel;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.selection.SelectionPanel;
import vswe.stevesfactory.ui.manager.tool.ToolPanel;
import vswe.stevesfactory.ui.manager.tool.group.GroupDataModel;
import vswe.stevesfactory.ui.manager.toolbox.ToolboxPanel;

public class FactoryManagerGUI
extends WidgetScreen<FactoryManagerContainer> {
    public static final StrictTableLayout DOWN_RIGHT_4_STRICT_TABLE = new StrictTableLayout(StrictTableLayout.GrowDirection.DOWN, StrictTableLayout.GrowDirection.RIGHT, 4);
    public static final ResourceLocation DELETE_ICON = RenderingHelper.linkTexture("gui/actions/delete.png");
    public static final ResourceLocation COPY_ICON = RenderingHelper.linkTexture("gui/actions/copy.png");
    public static final ResourceLocation CUT_ICON = RenderingHelper.linkTexture("gui/actions/cut.png");
    public static final ResourceLocation PASTE_ICON = RenderingHelper.linkTexture("gui/actions/paste.png");
    public static final TextureWrapper CLOSE_ICON = TextureWrapper.ofFlowComponent(18, 36, 9, 9);
    public static final TextureWrapper CLOSE_ICON_HOVERED = CLOSE_ICON.toRight(1);
    public static final TextureWrapper SETTINGS_ICON = TextureWrapper.ofFlowComponent(18, 106, 18, 18);
    public static final TextureWrapper SETTINGS_ICON_HOVERED = SETTINGS_ICON.toRight(1);
    public static final TextureWrapper ADD_ENTRY_ICON = TextureWrapper.ofFlowComponent(18, 125, 8, 8);
    public static final TextureWrapper ADD_ENTRY_HOVERED_ICON = ADD_ENTRY_ICON.toRight(1);
    public static final TextureWrapper REMOVE_ENTRY_ICON = TextureWrapper.ofFlowComponent(34, 125, 8, 8);
    public static final TextureWrapper REMOVE_ENTRY_HOVERED_ICON = REMOVE_ENTRY_ICON.toRight(1);
    public static final int FIXED_WIDTH = 256;
    public static final int FIXED_HEIGHT = 180;
    public static final float WIDTH_PROPORTION = 0.6666667f;
    public static final float HEIGHT_PROPORTION = 0.75f;
    public final GroupDataModel groupModel = new GroupDataModel(this);

    public static FactoryManagerGUI get() {
        return (FactoryManagerGUI)Minecraft.func_71410_x().field_71462_r;
    }

    public FactoryManagerGUI(FactoryManagerContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    protected void init() {
        super.init();
        PrimaryWindow w = new PrimaryWindow();
        this.initializePrimaryWindow(w);
        w.init();
    }

    @Override
    public void removed() {
        this.getPrimaryWindow().topLevel.editorPanel.saveAll();
        super.removed();
    }

    public INetworkController getController() {
        return ((FactoryManagerContainer)this.field_147002_h).controller;
    }

    @Override
    public PrimaryWindow getPrimaryWindow() {
        return (PrimaryWindow)super.getPrimaryWindow();
    }

    public TopLevelWidget getTopLevel() {
        return this.getPrimaryWindow().topLevel;
    }

    public static class TopLevelWidget
    extends AbstractContainer<DynamicWidthWidget<?>> {
        public final SelectionPanel selectionPanel = new SelectionPanel();
        public final EditorPanel editorPanel = new EditorPanel();
        public final ConnectionsPanel connectionsPanel = new ConnectionsPanel();
        public final ToolPanel toolPanel = new ToolPanel();
        public final ToolboxPanel toolboxPanel = new ToolboxPanel();
        private final ImmutableList<DynamicWidthWidget<?>> children = ImmutableList.of((Object)this.selectionPanel, (Object)this.connectionsPanel, (Object)this.editorPanel, (Object)this.toolPanel, (Object)this.toolboxPanel);
        private int prevWidth;
        private int prevHeight;

        private TopLevelWidget(PrimaryWindow window) {
            super(window);
        }

        public void init() {
            this.attachChildren();
            this.editorPanel.readProcedures();
        }

        @Override
        public IWidget getParentWidget() {
            return null;
        }

        @Override
        public void setParentWidget(IWidget newParent) {
            Preconditions.checkArgument((newParent == null ? 1 : 0) != 0);
        }

        @Override
        public void onParentPositionChanged() {
        }

        @Override
        public List<DynamicWidthWidget<?>> getChildren() {
            return this.children;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            for (DynamicWidthWidget child : this.children) {
                child.render(mouseX, mouseY, particleTicks);
            }
        }

        @Override
        public void reflow() {
            this.fillWindow();
            if (this.getWidth() != this.prevWidth || this.getHeight() != this.prevHeight) {
                this.prevWidth = this.getWidth();
                this.prevHeight = this.getHeight();
                this.selectionPanel.setHeight(this.prevHeight);
                this.editorPanel.setHeight(this.prevHeight);
                this.connectionsPanel.setHeight(this.prevHeight);
                this.toolPanel.setHeight(this.prevHeight);
                this.toolboxPanel.setHeight(this.prevHeight);
            }
            this.selectionPanel.reflow();
            this.editorPanel.reflow();
            this.connectionsPanel.reflow();
            this.toolPanel.reflow();
            this.toolboxPanel.reflow();
            DynamicWidthWidget.reflowDynamicWidth(this.getDimensions(), this.children);
        }
    }

    public static class PrimaryWindow
    extends AbstractWindow {
        public final TopLevelWidget topLevel;
        private Rectangle screenBounds = new Rectangle();
        private boolean fullscreen = false;
        private int backgroundDL;

        private PrimaryWindow() {
            this.topLevel = new TopLevelWidget(this);
        }

        public void init() {
            this.topLevel.init();
            this.setFocusedWidget(this.topLevel);
            this.asProportional();
        }

        @Override
        public int getBorderSize() {
            return 4;
        }

        @Override
        public List<? extends IWidget> getChildren() {
            return ImmutableList.of((Object)this.topLevel);
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            if (this.fullscreen && !((Boolean)Config.CLIENT.useBackgroundOnFullscreen.get()).booleanValue()) {
                RenderingHelper.drawRect(this.getPosition(), this.getBorder(), -3750202);
            } else {
                GL11.glCallList((int)this.backgroundDL);
            }
            this.topLevel.render(mouseX, mouseY, particleTicks);
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }

        public Rectangle getScreenBounds() {
            return this.screenBounds;
        }

        public void setScreenBounds(int width, int height) {
            this.screenBounds.width = width;
            this.screenBounds.height = height;
            this.screenBounds.x = WidgetScreen.screenWidth() / 2 - width / 2;
            this.screenBounds.y = WidgetScreen.screenHeight() / 2 - height / 2;
            this.setPosition(this.screenBounds.x, this.screenBounds.y);
            this.setBorder(width, height);
            this.updateBackgroundDL();
        }

        private void updateBackgroundDL() {
            this.backgroundDL = DisplayListCaches.createVanillaStyleBackground(new Rectangle(this.screenBounds), 0.0f);
        }

        private void asProportional() {
            int height;
            int width;
            if (((Boolean)Config.CLIENT.useFixedSizeScreen.get()).booleanValue()) {
                width = 256;
                height = 180;
            } else {
                width = (int)((float)WidgetScreen.screenWidth() * 0.6666667f);
                height = (int)((float)WidgetScreen.screenHeight() * 0.75f);
            }
            this.setScreenBounds(width, height);
            this.topLevel.reflow();
            FactoryManagerGUI.get().field_146999_f = width;
            FactoryManagerGUI.get().field_147000_g = height;
        }

        private void asFullscreen() {
            this.setScreenBounds(WidgetScreen.screenWidth(), WidgetScreen.screenHeight());
            this.topLevel.reflow();
        }

        public void toggleFullscreen() {
            boolean bl = this.fullscreen = !this.fullscreen;
            if (this.fullscreen) {
                this.asFullscreen();
            } else {
                this.asProportional();
            }
        }
    }
}

