/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.util.Map;
import java.util.function.Function;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.ConnectionsPanel;
import vswe.stevesfactory.ui.manager.editor.EndNode;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.INode;
import vswe.stevesfactory.ui.manager.editor.IntermediateNode;
import vswe.stevesfactory.ui.manager.editor.StartNode;

public abstract class ConnectionNodes<N extends INode>
extends AbstractContainer<N>
implements IWidget {
    private final ImmutableList<N> nodes;

    public static ConnectionNodes<EndNode> inputNodes(int amount) {
        return new ConnectionNodes<EndNode>(amount, EndNode::new){

            @Override
            public void readConnections(Map<IProcedure, FlowComponent<?>> m, IProcedure procedure) {
            }
        };
    }

    public static ConnectionNodes<StartNode> outputNodes(int amount) {
        return new ConnectionNodes<StartNode>(amount, StartNode::new){

            @Override
            public void readConnections(Map<IProcedure, FlowComponent<?>> m, IProcedure procedure) {
                ImmutableList nodes = this.getChildren();
                Connection[] successors = procedure.successors();
                Preconditions.checkState((successors.length == nodes.size() ? 1 : 0) != 0);
                for (int i = 0; i < successors.length; ++i) {
                    Connection connection = successors[i];
                    if (connection == null) continue;
                    IProcedure successor = connection.getDestination();
                    FlowComponent<?> other = m.get(successor);
                    StartNode start = (StartNode)nodes.get(i);
                    EndNode end = (EndNode)((ConnectionNodes)other.getInputNodes()).nodes.get(connection.getDestinationInputIndex());
                    String group = other.getGroup();
                    INode[] allNodes = new INode[1 + connection.getPolylineNodes().size() + 1];
                    allNodes[0] = start;
                    allNodes[allNodes.length - 1] = end;
                    FactoryManagerGUI.get().getTopLevel().connectionsPanel.addChildren(group, start.shadow);
                    FactoryManagerGUI.get().getTopLevel().connectionsPanel.addChildren(group, end.shadow);
                    int j = 1;
                    for (Point pos : connection.getPolylineNodes()) {
                        allNodes[j] = new IntermediateNode();
                        allNodes[j].setLocation(pos);
                        FactoryManagerGUI.get().getTopLevel().connectionsPanel.addChildren(group, allNodes[j]);
                        ++j;
                    }
                    for (int k = 0; k < allNodes.length - 1; ++k) {
                        INode from = allNodes[k];
                        INode to = allNodes[k + 1];
                        ConnectionsPanel.connect(from, to);
                    }
                }
            }
        };
    }

    public ConnectionNodes(int amountNodes, Function<Integer, N> factory) {
        super(0, 0, 0, 6);
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (int i = 0; i < amountNodes; ++i) {
            INode node = (INode)factory.apply(i);
            nodes.add((Object)node);
        }
        this.nodes = nodes.build();
    }

    private static void removeNode(INode node) {
        ConnectionsPanel panel = FactoryManagerGUI.get().getTopLevel().connectionsPanel;
        panel.removeChildren(node);
    }

    @Override
    public void reflow() {
        int segmentsWidth;
        int segments = this.nodes.size() + 1;
        int emptyWidth = this.getWidth() - this.nodes.size() * 7;
        int x = segmentsWidth = emptyWidth / segments;
        for (INode node : this.nodes) {
            node.setX(x);
            x += node.getWidth() + segmentsWidth;
        }
    }

    @Override
    public ImmutableList<N> getChildren() {
        return this.nodes;
    }

    public abstract void readConnections(Map<IProcedure, FlowComponent<?>> var1, IProcedure var2);

    public void removeAllConnections() {
        for (INode node : this.nodes) {
            if (node instanceof StartNode) {
                ConnectionsPanel.removeConnection((StartNode)node);
                continue;
            }
            ConnectionsPanel.removeConnection((EndNode)node);
        }
    }
}

