/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.math.BlockPos;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.ScissorTest;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.window.Dialog;
import vswe.stevesfactory.ui.manager.DynamicWidthWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.OffsetText;
import vswe.stevesfactory.ui.manager.tool.group.GroupDataModel;
import vswe.stevesfactory.utils.NetworkHelper;

public final class EditorPanel
extends DynamicWidthWidget<FlowComponent<?>> {
    private Map<String, TreeSet<FlowComponent<?>>> groupMappedChildren = new HashMap();
    private TreeSet<FlowComponent<?>> children;
    private Collection<FlowComponent<?>> childrenView;
    private int nextZIndex = 0;
    private OffsetText xOffset = new OffsetText(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Editor.XOff", (Object[])new Object[0]), 0, 0);
    private OffsetText yOffset;

    public EditorPanel() {
        super(DynamicWidthWidget.WidthOccupierType.MAX_WIDTH);
        this.xOffset.setParentWidget(this);
        this.yOffset = new OffsetText(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Editor.YOff", (Object[])new Object[0]), 0, 0);
        this.yOffset.setParentWidget(this);
        this.children = new TreeSet();
        this.childrenView = this.children.descendingSet();
        this.groupMappedChildren.put("", this.children);
        GroupDataModel data = FactoryManagerGUI.get().groupModel;
        data.addListenerRemove(this::onGroupRemoved);
        data.addListenerUpdate(this::onGroupUpdated);
        data.addListenerSelect(this::onGroupSelected);
    }

    private void onGroupRemoved(String group) {
        for (FlowComponent<?> component : this.children) {
            if (!component.getGroup().equals(group)) continue;
            FactoryManagerGUI.get().scheduleTask(__ -> component.remove());
        }
    }

    private void onGroupUpdated(String from, String to) {
        for (FlowComponent<?> component : this.children) {
            if (!component.getGroup().equals(from)) continue;
            component.setGroup(to);
        }
    }

    private void onGroupSelected(String current) {
        this.children = this.groupMappedChildren.computeIfAbsent(current, __ -> new TreeSet());
        this.childrenView = this.children.descendingSet();
    }

    public TreeSet<FlowComponent<?>> getFlowComponents() {
        return this.children;
    }

    @Override
    public Collection<FlowComponent<?>> getChildren() {
        return this.childrenView;
    }

    @Override
    public void reflow() {
    }

    public EditorPanel addChildren(FlowComponent<?> widget) {
        widget.setParentWidget(this);
        widget.setZIndex(this.nextZIndex());
        this.children.add(widget);
        return this;
    }

    public EditorPanel addChildren(Collection<FlowComponent<?>> widgets) {
        for (FlowComponent<?> widget : widgets) {
            widget.setParentWidget(this);
            widget.setZIndex(this.nextZIndex());
        }
        this.children.addAll(widgets);
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        ScissorTest test = ScissorTest.scaled(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.xOffset.get(), (float)this.yOffset.get(), (float)0.0f);
        RenderingHelper.translate(this.xOffset.get(), this.yOffset.get());
        int translatedX = mouseX - this.xOffset.get();
        int translatedY = mouseY - this.yOffset.get();
        for (FlowComponent<?> child : this.children) {
            child.render(translatedX, translatedY, particleTicks);
        }
        RenderingHelper.clearTranslation();
        RenderSystem.popMatrix();
        test.destroy();
        this.xOffset.render(mouseX, mouseY, particleTicks);
        this.yOffset.render(mouseX, mouseY, particleTicks);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double translatedX = mouseX - (double)this.xOffset.get();
        double translatedY = mouseY - (double)this.yOffset.get();
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.mouseClicked(translatedX, translatedY, button)) continue;
            this.raiseComponentToTop(child);
            return true;
        }
        if (this.xOffset.isInside(mouseX, mouseY)) {
            return this.xOffset.mouseClicked(mouseX, mouseY, button);
        }
        if (this.yOffset.isInside(mouseX, mouseY)) {
            return this.yOffset.mouseClicked(mouseX, mouseY, button);
        }
        if (this.isInside(mouseX, mouseY)) {
            switch (button) {
                case 0: {
                    this.getWindow().setFocusedWidget(this);
                    break;
                }
                case 1: {
                    this.openActionMenu();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.xOffset.isInside(mouseX, mouseY)) {
            return this.xOffset.mouseReleased(mouseX, mouseY, button);
        }
        if (this.yOffset.isInside(mouseX, mouseY)) {
            return this.yOffset.mouseReleased(mouseX, mouseY, button);
        }
        double translatedX = mouseX - (double)this.xOffset.get();
        double translatedY = mouseY - (double)this.yOffset.get();
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.mouseReleased(translatedX, translatedY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isFocused()) {
            this.xOffset.add((int)Math.round(deltaX));
            this.yOffset.add((int)Math.round(deltaY));
        }
        if (this.xOffset.isInside(mouseX, mouseY)) {
            return this.xOffset.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.yOffset.isInside(mouseX, mouseY)) {
            return this.yOffset.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.mouseDragged(mouseX - (double)this.xOffset.get(), mouseY - (double)this.yOffset.get(), button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.xOffset.isInside(mouseX, mouseY)) {
            return this.xOffset.mouseScrolled(mouseX, mouseY, scroll);
        }
        if (this.yOffset.isInside(mouseX, mouseY)) {
            return this.yOffset.mouseScrolled(mouseX, mouseY, scroll);
        }
        double translatedX = mouseX - (double)this.xOffset.get();
        double translatedY = mouseY - (double)this.yOffset.get();
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.mouseScrolled(translatedX, translatedY, scroll)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.xOffset.isInside(mouseX, mouseY)) {
            this.xOffset.mouseMoved(mouseX, mouseY);
        }
        if (this.yOffset.isInside(mouseX, mouseY)) {
            this.yOffset.mouseMoved(mouseX, mouseY);
        }
        for (FlowComponent<?> child : this.getChildren()) {
            child.mouseMoved(mouseX - (double)this.xOffset.get(), mouseY - (double)this.yOffset.get());
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        int offset = Screen.hasShiftDown() ? ((Integer)Config.CLIENT.acceleratedEditorMoveSpeed.get()).intValue() : ((Integer)Config.CLIENT.defaultEditorMoveSpeed.get()).intValue();
        switch (keyCode) {
            case 265: {
                this.yOffset.add(offset);
                break;
            }
            case 264: {
                this.yOffset.subtract(offset);
                break;
            }
            case 263: {
                this.xOffset.add(offset);
                break;
            }
            case 262: {
                this.xOffset.subtract(offset);
            }
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char charTyped, int keyCode) {
        for (FlowComponent<?> child : this.getChildren()) {
            if (!child.charTyped(charTyped, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(float particleTicks) {
        for (FlowComponent<?> child : this.getChildren()) {
            child.update(particleTicks);
        }
    }

    private void openActionMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(FactoryManagerGUI.PASTE_ICON, "gui.sfm.FactoryManager.Editor.CtxMenu.Paste", b -> this.actionPaste()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Editor.CtxMenu.CleanupProcedures", b -> this.actionCleanup()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Generic.CtxMenu.ToggleFullscreen", b -> FactoryManagerGUI.get().getPrimaryWindow().toggleFullscreen())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }

    private void actionPaste() {
        CompoundNBT tag;
        String json = Minecraft.func_71410_x().field_195559_v.func_197965_a();
        try {
            tag = JsonToNBT.func_180713_a((String)json);
        }
        catch (CommandSyntaxException e) {
            Dialog.createDialog("gui.sfm.FactoryManager.Editor.Dialog.PasteProcedure.Fail").tryAddSelfToActiveGUI();
            return;
        }
        INetworkController controller = FactoryManagerGUI.get().getController();
        IProcedure procedure = NetworkHelper.retrieveProcedureAndAdd(controller, tag);
        this.addChildren(procedure.createFlowComponent());
    }

    private void actionCleanup() {
    }

    @Override
    public void onRelativePositionChanged() {
        super.onRelativePositionChanged();
        this.updateOffsets();
    }

    @Override
    public void onParentPositionChanged() {
        super.onParentPositionChanged();
        this.updateOffsets();
    }

    private void updateOffsets() {
        this.xOffset.onParentPositionChanged();
        this.yOffset.onParentPositionChanged();
    }

    @Override
    public void onAfterReflow() {
        int statusX = this.getWidth() - 4;
        RenderingHelper.fontRenderer().getClass();
        int fontHeight = 9;
        int yStatusY = this.getHeight() - 4 - fontHeight;
        this.xOffset.rightX = statusX;
        this.xOffset.setY(yStatusY - 4 - fontHeight);
        this.xOffset.update();
        this.yOffset.rightX = statusX;
        this.yOffset.setY(yStatusY);
        this.yOffset.update();
    }

    public void removeFlowComponent(FlowComponent<?> flowComponent) {
        this.children.remove(flowComponent);
        flowComponent.onRemoved();
    }

    private void raiseComponentToTop(FlowComponent<?> target) {
        target.setZIndex(this.nextZIndex());
        this.updateChild(target);
    }

    private int nextZIndex() {
        return this.nextZIndex++;
    }

    private int getLastDistributedZIndex() {
        return this.nextZIndex - 1;
    }

    private void updateChild(FlowComponent<?> child) {
        this.children.remove(child);
        this.children.add(child);
    }

    public void saveAll() {
        for (TreeSet<FlowComponent<?>> children : this.groupMappedChildren.values()) {
            for (FlowComponent<?> child : children) {
                child.save();
            }
        }
    }

    public void readProcedures() {
        BlockPos controllerPos = ((FactoryManagerGUI)WidgetScreen.getCurrent()).getController().getPosition();
        INetworkController controller = Objects.requireNonNull((INetworkController)Minecraft.func_71410_x().field_71441_e.func_175625_s(controllerPos));
        FactoryManagerGUI.get().getTopLevel().connectionsPanel.disabledModification = true;
        HashMap m = new HashMap();
        for (IProcedure iProcedure : controller.getPGraph().iterableValidAll()) {
            FlowComponent<?> f = iProcedure.createFlowComponent();
            f.setParentWidget(this);
            f.setZIndex(this.nextZIndex());
            m.put(iProcedure, f);
            this.groupMappedChildren.computeIfAbsent(f.getGroup(), __ -> new TreeSet()).add(f);
        }
        FactoryManagerGUI.get().getTopLevel().connectionsPanel.disabledModification = false;
        for (TreeSet treeSet : this.groupMappedChildren.values()) {
            for (FlowComponent child : treeSet) {
                child.readConnections(m);
            }
        }
    }

    public int getXOffset() {
        return this.xOffset.get();
    }

    public int getYOffset() {
        return this.yOffset.get();
    }

    public void moveGroup(String from, String to) {
        TreeSet original = this.groupMappedChildren.computeIfAbsent(from, __ -> new TreeSet());
        this.groupMappedChildren.computeIfAbsent(to, __ -> new TreeSet()).addAll(original);
        for (FlowComponent component : original) {
            component.setGroup(to);
        }
        original.clear();
    }

    @Override
    public void notifyChildrenForPositionChange() {
        for (TreeSet<FlowComponent<?>> children : this.groupMappedChildren.values()) {
            for (FlowComponent<?> child : children) {
                child.onParentPositionChanged();
            }
        }
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("XOff=" + this.xOffset.get());
        receiver.line("YOff=" + this.yOffset.get());
    }
}

