/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.ConnectionNodes;
import vswe.stevesfactory.ui.manager.editor.ConnectionsPanel;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.INode;
import vswe.stevesfactory.ui.manager.editor.IntermediateNode;
import vswe.stevesfactory.ui.manager.editor.ShadowNode;
import vswe.stevesfactory.ui.manager.editor.StartNode;

public final class EndNode
extends AbstractIconButton
implements INode {
    public static final TextureWrapper INPUT_NORMAL = TextureWrapper.ofFlowComponent(18, 51, 7, 6);
    public static final TextureWrapper INPUT_HOVERED = INPUT_NORMAL.toRight(1);
    private INode previous;
    private StartNode start;
    public final int index;
    public final ShadowNode shadow;

    public EndNode(int index) {
        super(0, 0, 7, 6);
        this.index = index;
        this.shadow = new ShadowNode(this);
        FactoryManagerGUI.get().getTopLevel().connectionsPanel.addChildren(this.shadow);
    }

    @Override
    public void onParentPositionChanged() {
        super.onParentPositionChanged();
        this.updateShadowPosition();
    }

    @Override
    public void onRelativePositionChanged() {
        super.onRelativePositionChanged();
        this.updateShadowPosition();
    }

    private void updateShadowPosition() {
        EditorPanel editor = FactoryManagerGUI.get().getTopLevel().editorPanel;
        int x = this.getAbsoluteX() - editor.getAbsoluteX();
        int y = this.getAbsoluteY() - editor.getAbsoluteY();
        this.shadow.setLocation(x, y);
    }

    @Override
    public void onRemoved() {
        FactoryManagerGUI.get().getTopLevel().connectionsPanel.removeChildren(this.shadow);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                this.getWindow().setFocusedWidget(this);
                return true;
            }
            case 1: {
                ConnectionsPanel.removeConnection(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.previous != null) {
            IntermediateNode.dragOutIntermediateNode(this.previous, this, (int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isFocused()) {
            FactoryManagerGUI.get().getTopLevel().connectionsPanel.onTerminalNodeClick((Either<StartNode, EndNode>)Either.right((Object)this), button);
            return true;
        }
        return false;
    }

    @Override
    public void connectTo(INode next) {
    }

    @Override
    public void connectFrom(INode previous) {
        if (previous instanceof StartNode) {
            this.start = (StartNode)previous;
        }
        this.previous = previous;
    }

    @Override
    public void disconnectNext() {
    }

    @Override
    public void disconnectPrevious() {
        if (this.previous == this.start) {
            this.start = null;
        }
        this.previous = null;
    }

    @Override
    @Nullable
    public INode getPrevious() {
        return this.previous;
    }

    @Override
    @Nullable
    public INode getNext() {
        return null;
    }

    @Override
    public TextureWrapper getTextureNormal() {
        return INPUT_NORMAL;
    }

    @Override
    public TextureWrapper getTextureHovered() {
        return INPUT_HOVERED;
    }

    public boolean isConnected() {
        return this.start != null;
    }

    @Override
    public INode.Type getType() {
        return INode.Type.END;
    }

    public StartNode getStart() {
        return this.start;
    }

    @Override
    @Nonnull
    public ConnectionNodes<?> getParentWidget() {
        return (ConnectionNodes)Objects.requireNonNull(super.getParentWidget());
    }

    public FlowComponent<?> getFlowComponent() {
        return (FlowComponent)((AbstractWidget)this.getParentWidget()).getParentWidget();
    }

    public IProcedure getProcedure() {
        return this.getFlowComponent().getProcedure();
    }
}

