/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.ConnectionsPanel;
import vswe.stevesfactory.ui.manager.editor.INode;
import vswe.stevesfactory.utils.Utils;

public class IntermediateNode
extends AbstractWidget
implements INode,
LeafWidgetMixin {
    public static final int BORDER = -11711155;
    public static final int NORMAL_FILLER = -6447715;
    public static final int HOVERED_FILLER = -3684409;
    public static final int NODE_WIDTH = 6;
    public static final int NODE_HEIGHT = 6;
    private INode previous;
    private INode next;
    private int initialDragLocalX = -1;
    private int initialDragLocalY = -1;

    public static IntermediateNode dragOutIntermediateNode(INode start, INode end, int mouseX, int mouseY) {
        FactoryManagerGUI.TopLevelWidget topLevel = FactoryManagerGUI.get().getTopLevel();
        IntermediateNode node = ConnectionsPanel.subdivideConnection(start, end);
        topLevel.connectionsPanel.addChildren(node);
        node.setLocation(mouseX - topLevel.editorPanel.getAbsoluteX(), mouseY - topLevel.editorPanel.getAbsoluteY());
        node.startDrag(mouseX, mouseY);
        return node;
    }

    public IntermediateNode() {
        super(0, 0, 6, 6);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        RenderSystem.disableTexture();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int x1 = this.getAbsoluteX();
        int y1 = this.getAbsoluteY();
        int x2 = this.getAbsoluteXRight();
        int y2 = this.getAbsoluteYBottom();
        RenderingHelper.rectVertices(x1, y1, x2, y2, -11711155);
        RenderingHelper.rectVertices(x1 + 1, y1 + 1, x2 - 1, y2 - 1, Utils.isInside(mouseX, mouseY, x1, y1, x2, y2) ? -3684409 : -6447715);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                this.startDrag((int)mouseX, (int)mouseY);
                break;
            }
            case 1: {
                ConnectionsPanel.mergeConnection(this.previous, this.next, this);
                FactoryManagerGUI.get().getTopLevel().connectionsPanel.removeChildren(this);
            }
        }
        return true;
    }

    void startDrag(int mouseX, int mouseY) {
        this.initialDragLocalX = mouseX - this.getAbsoluteX();
        this.initialDragLocalY = mouseY - this.getAbsoluteY();
        this.getWindow().setFocusedWidget(this);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging()) {
            ConnectionsPanel parent = FactoryManagerGUI.get().getTopLevel().connectionsPanel;
            int x = (int)mouseX - parent.getAbsoluteX() - this.initialDragLocalX;
            int y = (int)mouseY - parent.getAbsoluteY() - this.initialDragLocalY;
            this.setLocation(x, y);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.clearDrag();
        return true;
    }

    private void clearDrag() {
        this.initialDragLocalX = -1;
        this.initialDragLocalY = -1;
    }

    private boolean isDragging() {
        return this.initialDragLocalX != -1 && this.initialDragLocalY != -1;
    }

    @Override
    @Nullable
    public INode getPrevious() {
        return this.previous;
    }

    @Override
    @Nullable
    public INode getNext() {
        return this.next;
    }

    @Override
    public void connectTo(INode next) {
        this.next = next;
    }

    @Override
    public void connectFrom(INode previous) {
        this.previous = previous;
    }

    @Override
    public void disconnectNext() {
        this.next = null;
    }

    @Override
    public void disconnectPrevious() {
        this.previous = null;
    }

    @Override
    public void onEdgeRemoval() {
        FactoryManagerGUI.get().getTopLevel().connectionsPanel.removeChildren(this);
    }

    @Override
    public INode.Type getType() {
        return INode.Type.INTERMEDIATE;
    }
}

