/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.ITrigger;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.ScissorTest;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.box.LinearList;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.logic.procedure.FunctionInvokeProcedure;
import vswe.stevesfactory.logic.procedure.IFunctionHat;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;

public class InvocationTargetMenu
extends Menu<FunctionInvokeProcedure> {
    public static final int HORIZONTAL_MARGIN = 4;
    public static final int VERTICAL_MARGIN = 2;
    private LinearList<ListEntry> options = new LinearList(this.getWidth() - 8, this.getContentHeight() - 4);
    private int selected = -1;

    public InvocationTargetMenu() {
        this.options.setLocation(4, HEADING_BOX.getPortionHeight() + 2);
        this.addChildren(this.options);
        this.injectAction(() -> new CallbackEntry(null, "menu.sfm.InvocationTarget.CtxMenu.Rescan", b -> this.scanTargets()));
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<FunctionInvokeProcedure> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        this.scanTargets();
    }

    private void scanTargets() {
        EditorPanel editor = FactoryManagerGUI.get().getTopLevel().editorPanel;
        FunctionInvokeProcedure p = (FunctionInvokeProcedure)this.getLinkedProcedure();
        int i = 0;
        for (FlowComponent<?> component : editor.getFlowComponents()) {
            if (!(component.getProcedure() instanceof ITrigger)) continue;
            ITrigger trigger = (ITrigger)component.getProcedure();
            ListEntry entry = new ListEntry(component, i);
            entry.setWidth(this.options.getWidth() - this.options.getBarWidth());
            this.options.addChildren((IWidget)entry);
            if (trigger == p.getTarget()) {
                this.selected = i;
            }
            ++i;
        }
        this.options.reflow();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (!this.isInside(mouseX, mouseY)) {
            return false;
        }
        return false;
    }

    @Override
    public String getHeadingText() {
        return I18n.func_135052_a((String)"menu.sfm.InvocationTarget", (Object[])new Object[0]);
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        if (this.selected == -1) {
            errors.add(I18n.func_135052_a((String)"error.sfm.InvocationTarget.Unspecified", (Object[])new Object[0]));
        }
        return errors;
    }

    private class ListEntry
    extends AbstractWidget
    implements LeafWidgetMixin {
        private final FlowComponent<?> target;
        private final int index;

        public ListEntry(FlowComponent<?> target, int index) {
            super(0, 0, 0, 14);
            this.target = target;
            this.index = index;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                InvocationTargetMenu.this.selected = this.index;
                ((FunctionInvokeProcedure)InvocationTargetMenu.this.getLinkedProcedure()).setTarget((IProcedure)this.target.getProcedure());
            }
            return true;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            RenderingHelper.usePlainColorGLStates();
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int x1 = this.getAbsoluteX();
            int y1 = this.getAbsoluteY();
            int x2 = this.getAbsoluteXRight();
            int y2 = this.getAbsoluteYBottom();
            RenderingHelper.rectVertices(x1, y1, x2, y2, InvocationTargetMenu.this.selected == this.index ? -154 : -7566196);
            RenderingHelper.rectVertices(x1 + 1, y1 + 1, x2 - 1, y2 - 1, this.isInside(mouseX, mouseY) ? -9211021 : -3552823);
            Tessellator.func_178181_a().func_78381_a();
            ScissorTest test = ScissorTest.scaled(x1, y1, x2, y2);
            String name = this.target.getName();
            if (this.target.getProcedure() instanceof IFunctionHat) {
                name = name + " (" + ((IFunctionHat)this.target.getProcedure()).getFunctionName() + ")";
            }
            RenderingHelper.drawTextCenteredVertically(name, x1 + 2, y1, y2, -16777216);
            test.destroy();
            if (this.isInside(mouseX, mouseY)) {
                FactoryManagerGUI.get().setHoveringText(name, mouseX, mouseY);
            }
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }
    }
}

