/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.Checkbox;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.library.gui.widget.RadioButton;
import vswe.stevesfactory.library.gui.widget.RadioController;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.box.LinearList;
import vswe.stevesfactory.logic.FilterType;
import vswe.stevesfactory.logic.item.ItemTagFilter;
import vswe.stevesfactory.logic.procedure.IItemFilterTarget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.MultiLayerMenu;
import vswe.stevesfactory.ui.manager.menu.SettingsEditor;

public class ItemTagFilterMenu<P extends IProcedure & IClientDataStorage>
extends MultiLayerMenu<P> {
    private final int id;
    private final String name;
    private final RadioButton whitelist;
    private final RadioButton blacklist;
    private final LinearList<Entry> fields;
    private SettingsEditor settings;

    public ItemTagFilterMenu(int id) {
        this(id, I18n.func_135052_a((String)"menu.sfm.ItemFilter.Tag", (Object[])new Object[0]));
    }

    public ItemTagFilterMenu(int id, String name) {
        this.id = id;
        this.name = name;
        RadioController filterTypeController = new RadioController();
        this.whitelist = new RadioButton(filterTypeController);
        this.blacklist = new RadioButton(filterTypeController);
        int y = HEADING_BOX.getPortionHeight() + 4;
        this.whitelist.setLocation(4, y);
        this.whitelist.setLabel(I18n.func_135052_a((String)"gui.sfm.whitelist", (Object[])new Object[0]));
        this.blacklist.setLocation(this.getWidth() / 2, y);
        this.blacklist.setLabel(I18n.func_135052_a((String)"gui.sfm.blacklist", (Object[])new Object[0]));
        int contentY = this.whitelist.getYBottom() + 4;
        MultiLayerMenu.OpenSettingsButton openSettings = new MultiLayerMenu.OpenSettingsButton(this.getWidth() - 2 - 12, this.getHeight() + this.getContentHeight() - 2 - 12);
        AbstractIconButton addEntryButton = new AbstractIconButton(this.getWidth() - 4 - 8, contentY, 8, 8){

            @Override
            public TextureWrapper getTextureNormal() {
                return FactoryManagerGUI.ADD_ENTRY_ICON;
            }

            @Override
            public TextureWrapper getTextureHovered() {
                return FactoryManagerGUI.ADD_ENTRY_HOVERED_ICON;
            }

            @Override
            public void render(int mouseX, int mouseY, float particleTicks) {
                super.render(mouseX, mouseY, particleTicks);
                if (this.isHovered()) {
                    WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Tags.AddEntry", (Object[])new Object[0]), mouseX, mouseY);
                }
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                ItemTagFilterMenu.this.fields.addChildren(new Entry());
                ItemTagFilterMenu.this.fields.reflow();
                return true;
            }
        };
        this.fields = new LinearList(addEntryButton.getX() - 8, this.getContentHeight() - this.whitelist.getHeight() - 8);
        this.fields.setLocation(4, contentY);
        this.addChildren(this.whitelist);
        this.addChildren(this.blacklist);
        this.addChildren(this.fields);
        this.addChildren(addEntryButton);
        this.addChildren(openSettings);
    }

    @Override
    public SettingsEditor getEditor() {
        return this.settings;
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        ItemTagFilter filter = this.getLinkedFilter();
        Set<Tag<Item>> tags = filter.getTags();
        if (tags.isEmpty()) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.fields.addChildren((IWidget)new Entry());
            }
        } else {
            for (Tag<Item> tag : tags) {
                Entry entry = new Entry();
                entry.readTag(tag);
                this.fields.addChildren((IWidget)entry);
            }
        }
        this.fields.reflow();
        switch (filter.type) {
            case WHITELIST: {
                this.whitelist.check(true);
                break;
            }
            case BLACKLIST: {
                this.blacklist.check(true);
            }
        }
        this.whitelist.onChecked = () -> {
            filter.type = FilterType.WHITELIST;
        };
        this.blacklist.onChecked = () -> {
            filter.type = FilterType.BLACKLIST;
        };
        this.settings = new SettingsEditor(this);
        NumberField<Integer> stackLimitInput = this.settings.addIntegerInput(1, 0, Integer.MAX_VALUE);
        stackLimitInput.setValue(filter.stackLimit);
        stackLimitInput.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
        stackLimitInput.setLabel(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits.Amount", (Object[])new Object[0]));
        stackLimitInput.onValueUpdated = i -> {
            filter.stackLimit = i;
        };
        Checkbox checkbox = this.settings.addOption(filter.isMatchingAmount(), "menu.sfm.ItemFilter.Traits.MatchAmount");
        checkbox.onStateChange = b -> {
            filter.setMatchingAmount(b);
            stackLimitInput.setEnabled(b);
        };
    }

    @Override
    protected void saveData() {
        super.saveData();
        ItemTagFilter filter = this.getLinkedFilter();
        filter.getTags().clear();
        for (Entry entry : this.fields.getChildren()) {
            Tag<Item> tag = entry.createTag();
            if (tag == null) continue;
            filter.getTags().add(tag);
        }
    }

    public ItemTagFilter getLinkedFilter() {
        return (ItemTagFilter)((IItemFilterTarget)this.getLinkedProcedure()).getFilter(this.id);
    }

    @Override
    public String getHeadingText() {
        return this.name;
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        return errors;
    }

    private static class Entry
    extends AbstractContainer<IWidget> {
        private final TextField tag;
        private final List<IWidget> children;

        public Entry() {
            this.setDimensions(90, 14);
            this.tag = new TextField(0, 0, 75, this.getHeight());
            this.tag.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
            this.tag.setFontHeight(7);
            int buttonSize = 9;
            AbstractIconButton removeEntry = new AbstractIconButton(this.tag.getXRight() + 4, this.getHeight() / 2 - buttonSize / 2 - 1, buttonSize, buttonSize){

                @Override
                public TextureWrapper getTextureNormal() {
                    return FactoryManagerGUI.CLOSE_ICON;
                }

                @Override
                public TextureWrapper getTextureHovered() {
                    return FactoryManagerGUI.CLOSE_ICON_HOVERED;
                }

                @Override
                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    Entry entry = this;
                    IWidget list = entry.getParentWidget();
                    ((LinearList)list).getChildren().remove(entry);
                    ((LinearList)list).reflow();
                    return true;
                }
            };
            this.children = ImmutableList.of((Object)this.tag, (Object)removeEntry);
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            super.render(mouseX, mouseY, particleTicks);
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }

        @Override
        public Collection<IWidget> getChildren() {
            return this.children;
        }

        @Override
        public void reflow() {
        }

        public void readTag(Tag<Item> tag) {
            this.tag.setText(tag.func_199886_b().toString());
        }

        @Nullable
        public Tag<Item> createTag() {
            ResourceLocation id = new ResourceLocation(this.tag.getText());
            if (ItemTags.func_199903_a().func_199910_a(id) == null) {
                return null;
            }
            return new ItemTags.Wrapper(id);
        }

        @Override
        @Nonnull
        public LinearList<Entry> getParentWidget() {
            return (LinearList)Objects.requireNonNull(super.getParentWidget());
        }
    }
}

