/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.selection;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.library.collections.CompositeUnmodifiableList;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.DynamicWidthWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.selection.ComponentGroup;
import vswe.stevesfactory.ui.manager.selection.GroupComponentChoice;
import vswe.stevesfactory.ui.manager.selection.IComponentChoice;
import vswe.stevesfactory.ui.manager.selection.SingularComponentChoice;

public final class SelectionPanel
extends DynamicWidthWidget<IComponentChoice> {
    public static final ResourceLocation BACKGROUND_NORMAL = new ResourceLocation("sfm", "textures/gui/component_background/background_normal.png");
    public static final ResourceLocation BACKGROUND_HOVERED = new ResourceLocation("sfm", "textures/gui/component_background/background_hovered.png");
    private final ImmutableList<IComponentChoice> staticIcons = this.createStaticIcons();
    private final List<IComponentChoice> addendumIcons = new ArrayList<IComponentChoice>();
    private final List<IComponentChoice> icons = CompositeUnmodifiableList.of(this.staticIcons, this.addendumIcons);

    public SelectionPanel() {
        super(DynamicWidthWidget.WidthOccupierType.MIN_WIDTH);
    }

    private ImmutableList<IComponentChoice> createStaticIcons() {
        ImmutableList.Builder icons = ImmutableList.builder();
        for (ComponentGroup componentGroup : ComponentGroup.groups) {
            icons.add((Object)new GroupComponentChoice(componentGroup));
        }
        for (IProcedureType iProcedureType : ComponentGroup.ungroupedTypes) {
            icons.add((Object)new SingularComponentChoice(iProcedureType));
        }
        return icons.build();
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        for (IComponentChoice icon : this.staticIcons) {
            icon.render(mouseX, mouseY, particleTicks);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public List<IComponentChoice> getChildren() {
        return this.icons;
    }

    @Override
    public void reflow() {
        this.setWidth(Integer.MAX_VALUE);
        FactoryManagerGUI.DOWN_RIGHT_4_STRICT_TABLE.reflow(this.getDimensions(), this.getChildren());
        int w = this.getChildren().stream().max(Comparator.comparingInt(IWidget::getX)).map(furthest -> furthest.getX() + furthest.getWidth()).orElse(0) + FactoryManagerGUI.DOWN_RIGHT_4_STRICT_TABLE.componentMargin;
        this.setWidth(w);
    }

    @Override
    @Nonnull
    public FactoryManagerGUI.TopLevelWidget getParentWidget() {
        return Objects.requireNonNull((FactoryManagerGUI.TopLevelWidget)super.getParentWidget());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY)) {
            if (button == 0) {
                this.getWindow().setFocusedWidget(this);
            } else if (button == 1) {
                this.openActionMenu();
            }
            return true;
        }
        return false;
    }

    private void openActionMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Generic.CtxMenu.ToggleFullscreen", b -> FactoryManagerGUI.get().getPrimaryWindow().toggleFullscreen())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }
}

