/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.tool.group;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.library.gui.window.Dialog;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.tool.group.Grouplist;

public class GroupButton
extends TextButton {
    private String group;

    public static String formatGroupName(String group) {
        return group.isEmpty() ? I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.DefaultGroup", (Object[])new Object[0]) : group;
    }

    public GroupButton(String name) {
        this.setGroup(name);
        this.setHeight(12);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                this.actionSwitchGroup();
                return true;
            }
            case 1: {
                this.openContextMenu();
                return true;
            }
        }
        return false;
    }

    private void openContextMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(FactoryManagerGUI.DELETE_ICON, "gui.sfm.FactoryManager.Tool.Group.CtxMenu.Delete", b -> this.actionDelete()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Tool.Group.CtxMenu.RenameGroup", b -> this.actionRename()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Tool.Group.CtxMenu.MoveContent", b -> this.actionMoveContent())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }

    private void actionSwitchGroup() {
        FactoryManagerGUI.get().groupModel.setCurrentGroup(this.group);
    }

    private void actionDelete() {
        GroupButton.getGroupList().delete(this.group);
    }

    private void actionRename() {
        Dialog.createPrompt("gui.sfm.FactoryManager.Tool.Group.Dialog.RenameGroup", (b, newName) -> {
            for (String group : FactoryManagerGUI.get().groupModel.getGroups()) {
                if (!newName.equals(group)) continue;
                Dialog.createDialog(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.Dialog.RenameFailed", (Object[])new Object[]{newName})).tryAddSelfToActiveGUI();
                return;
            }
            FactoryManagerGUI.get().groupModel.updateGroup(this.group, (String)newName);
        }).tryAddSelfToActiveGUI();
    }

    private void actionMoveContent() {
        Grouplist.createSelectGroupDialog(toGroup -> {
            if (!this.group.equals(toGroup)) {
                FactoryManagerGUI.get().getTopLevel().editorPanel.moveGroup(this.group, (String)toGroup);
                FactoryManagerGUI.get().getTopLevel().connectionsPanel.moveGroup(this.group, (String)toGroup);
            }
        }, () -> {}).tryAddSelfToActiveGUI();
    }

    private static Grouplist getGroupList() {
        return FactoryManagerGUI.get().getTopLevel().toolboxPanel.getGroupList();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
        this.setTextRaw(GroupButton.formatGroupName(group));
    }

    @Override
    public int getNormalBorderColor() {
        return this.isSelected() ? -154 : super.getNormalBorderColor();
    }

    @Override
    public int getHoveredBorderColor() {
        return this.isSelected() ? -256 : super.getNormalBorderColor();
    }

    private boolean isSelected() {
        return this.group.equals(FactoryManagerGUI.get().groupModel.getCurrentGroup());
    }
}

