/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.tool.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;

public final class GroupDataModel {
    public static final String DEFAULT_GROUP = "";
    private FactoryManagerGUI gui;
    private List<Consumer<String>> addListeners = new ArrayList<Consumer<String>>();
    private List<Consumer<String>> removeListeners = new ArrayList<Consumer<String>>();
    private List<BiConsumer<String, String>> updateListeners = new ArrayList<BiConsumer<String, String>>();
    private List<Consumer<String>> selectListeners = new ArrayList<Consumer<String>>();
    private String currentGroup = "";

    public GroupDataModel(FactoryManagerGUI gui) {
        this.gui = gui;
    }

    public int addListenerAdd(Consumer<String> listener) {
        this.addListeners.add(listener);
        return this.addListeners.size() - 1;
    }

    public void removeListenerAdd(int id) {
        this.addListeners.remove(id);
    }

    public int addListenerRemove(Consumer<String> listener) {
        this.removeListeners.add(listener);
        return this.removeListeners.size() - 1;
    }

    public void removeListenerRemove(int id) {
        this.removeListeners.remove(id);
    }

    public int addListenerUpdate(BiConsumer<String, String> listener) {
        this.updateListeners.add(listener);
        return this.updateListeners.size() - 1;
    }

    public void removeListenerUpdate(int id) {
        this.updateListeners.remove(id);
    }

    public int addListenerSelect(Consumer<String> listener) {
        this.selectListeners.add(listener);
        return this.selectListeners.size() - 1;
    }

    public void removeListenerSelect(int id) {
        this.selectListeners.remove(id);
    }

    public Collection<String> getGroups() {
        return this.gui.getController().getGroups();
    }

    public boolean addGroup(String group) {
        if (this.gui.getController().getGroups().add(group)) {
            for (Consumer<String> listener : this.addListeners) {
                listener.accept(group);
            }
            return true;
        }
        return false;
    }

    public boolean removeGroup(String group) {
        if (this.gui.getController().getGroups().remove(group)) {
            for (Consumer<String> listener : this.removeListeners) {
                listener.accept(group);
            }
            return true;
        }
        return false;
    }

    public boolean updateGroup(String from, String to) {
        if (this.gui.getController().getGroups().remove(from)) {
            this.gui.getController().getGroups().add(to);
            for (BiConsumer<String, String> listener : this.updateListeners) {
                listener.accept(from, to);
            }
            return true;
        }
        return false;
    }

    public String getCurrentGroup() {
        return this.currentGroup;
    }

    public boolean setCurrentGroup(String group) {
        if (!this.currentGroup.equals(group)) {
            this.currentGroup = group;
            for (Consumer<String> listener : this.selectListeners) {
                listener.accept(group);
            }
            return true;
        }
        return false;
    }
}

