/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.tool.group;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.Spacer;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.library.gui.widget.box.LinearList;
import vswe.stevesfactory.library.gui.window.Dialog;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.tool.group.GroupButton;
import vswe.stevesfactory.ui.manager.tool.group.GroupDataModel;

public class Grouplist
extends LinearList<GroupButton> {
    public static final int SEL_DIALOG_LIST_WIDTH = 280;
    public static final int SEL_DIALOG_LIST_HEIGHT = 160;

    public Grouplist() {
        super(64, 0);
        FactoryManagerGUI.get().groupModel.addListenerAdd(this::onGroupAdded);
        FactoryManagerGUI.get().groupModel.addListenerRemove(this::onGroupRemoved);
        FactoryManagerGUI.get().groupModel.addListenerUpdate(this::onGroupUpdated);
        FactoryManagerGUI.get().scheduleTask(__ -> {
            for (String group : FactoryManagerGUI.get().groupModel.getGroups()) {
                this.addChildren(new GroupButton(group));
            }
            this.reflow();
        });
    }

    private static Grouplist getGroupList() {
        return FactoryManagerGUI.get().getTopLevel().toolboxPanel.getGroupList();
    }

    private void onGroupAdded(String group) {
        this.addChildren(new GroupButton(group));
        this.reflow();
    }

    private void onGroupRemoved(String group) {
        int i = 0;
        for (GroupButton child : this.getChildren()) {
            if (child.getGroup().equals(group)) {
                int index = i;
                FactoryManagerGUI.get().scheduleTask(__ -> {
                    this.getChildren().remove(index);
                    this.reflow();
                });
            }
            ++i;
        }
    }

    private void onGroupUpdated(String from, String to) {
        for (GroupButton child : this.getChildren()) {
            if (!child.getGroup().equals(from)) continue;
            child.setGroup(to);
        }
    }

    public Grouplist addChildren(GroupButton widget) {
        super.addChildren(widget);
        widget.setWidth(this.calcButtonWidth());
        return this;
    }

    public Grouplist addChildren(Collection<GroupButton> widgets) {
        super.addChildren(widgets);
        for (GroupButton widget : widgets) {
            widget.setWidth(this.calcButtonWidth());
        }
        return this;
    }

    private int calcButtonWidth() {
        return this.getBarLeft() - 2;
    }

    @Override
    public int getMarginMiddle() {
        return 2;
    }

    public void delete(String group) {
        FactoryManagerGUI.get().groupModel.removeGroup(group);
    }

    public static Dialog createNewGroupDialog() {
        return Dialog.createPrompt("gui.sfm.FactoryManager.Tool.Group.Dialog.CreateGroup", (b, name) -> {
            boolean success = FactoryManagerGUI.get().groupModel.addGroup((String)name);
            if (!success) {
                Dialog.createDialog("gui.sfm.FactoryManager.Tool.Group.Dialog.CreateFailed").tryAddSelfToActiveGUI();
            }
        });
    }

    public static Dialog createSelectGroupDialog(Consumer<String> onConfirm, Runnable onCancel) {
        Dialog dialog = new Dialog();
        dialog.getMessageBox().addLine(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.Dialog.SelectGroup", (Object[])new Object[0]));
        TargetList list = new TargetList();
        dialog.insertBeforeButtons(list);
        GroupDataModel data = FactoryManagerGUI.get().groupModel;
        int addId = data.addListenerAdd(group -> {
            list.createTarget((String)group);
            list.reflow();
        });
        int removeId = data.addListenerRemove(group -> {
            int i = 0;
            for (Target target : list.getChildren()) {
                if (target.getGroup().equals(group)) {
                    int index = i;
                    FactoryManagerGUI.get().scheduleTask(__ -> {
                        Target cfr_ignored_0 = (Target)list.getChildren().remove(index);
                    });
                }
                ++i;
            }
        });
        int updateId = data.addListenerUpdate((from, to) -> {
            for (Target target : list.getChildren()) {
                if (!target.getGroup().equals(from)) continue;
                target.setGroup((String)to);
            }
        });
        dialog.getButtons().addChildren((IWidget)TextButton.of("gui.sfm.ok", b -> {
            onConfirm.accept(list.getSelectedGroup());
            data.removeListenerAdd(addId);
            data.removeListenerRemove(removeId);
            data.removeListenerUpdate(updateId);
        }));
        dialog.bindRemoveSelf2LastButton();
        dialog.getButtons().addChildren((IWidget)TextButton.of("gui.sfm.cancel", b -> {
            onCancel.run();
            data.removeListenerAdd(addId);
            data.removeListenerRemove(removeId);
            data.removeListenerUpdate(updateId);
        }));
        dialog.bindRemoveSelf2LastButton();
        dialog.getButtons().addChildren((IWidget)TextButton.of("gui.sfm.new", b -> Grouplist.createNewGroupDialog().tryAddSelfToActiveGUI()));
        dialog.insertBeforeButtons(new Spacer(0, 10));
        dialog.reflow();
        dialog.centralize();
        return dialog;
    }

    private static class Target
    extends TextButton {
        private final int index;
        private String group;

        public Target(int index, String group) {
            this.index = index;
            this.setGroup(group);
            this.setDimensions(272, 12);
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
            this.setTextRaw(GroupButton.formatGroupName(group));
        }

        @Override
        public int getNormalBorderColor() {
            return this.isSelected() ? -154 : super.getNormalBorderColor();
        }

        @Override
        public int getHoveredBorderColor() {
            return this.isSelected() ? -256 : super.getHoveredBorderColor();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.getParentWidget().selected = this.index;
            return true;
        }

        @Override
        @Nonnull
        public TargetList getParentWidget() {
            return (TargetList)Objects.requireNonNull(super.getParentWidget());
        }

        private boolean isSelected() {
            return this.getParentWidget().selected == this.index;
        }
    }

    private static class TargetList
    extends LinearList<Target> {
        private int selected = 0;

        public TargetList() {
            super(280, 160);
            for (String group : FactoryManagerGUI.get().groupModel.getGroups()) {
                this.createTarget(group);
            }
            this.reflow();
        }

        public void createTarget(String group) {
            int index = this.getChildren().size();
            Target target = new Target(index, group);
            this.addChildren(target);
            target.setWidth(this.getBarLeft() - 2);
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
            RenderingHelper.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteXRight(), this.getAbsoluteYBottom(), -5131855);
            super.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public int getMarginMiddle() {
            return 2;
        }

        public Target getSelected() {
            return (Target)this.getChildren().get(this.selected);
        }

        public String getSelectedGroup() {
            return this.getSelected().group;
        }
    }
}

