/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.capability.fluid;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GenericFluidEntityHandler
extends WorldSavedData {
    private final Map<BlockPos, LazyOptional<FluidTank>> ENTITIES = new HashMap<BlockPos, LazyOptional<FluidTank>>();
    private final Map<LazyOptional<FluidTank>, Set<BlockPos>> CAPABILITIES = new HashMap<LazyOptional<FluidTank>, Set<BlockPos>>();
    private final World world;
    private final Setup setup;

    public GenericFluidEntityHandler(@Nonnull World world, @Nonnull Setup setup) {
        super(setup.networkId);
        this.setup = setup;
        this.world = world;
    }

    public synchronized void register(@Nonnull BlockPos position) {
        if (position == BlockPos.field_177992_a || this.ENTITIES.containsKey(position)) {
            return;
        }
        this.registerEntity(position);
        this.func_76185_a();
    }

    public synchronized void remove(@Nonnull BlockPos position) {
        if (position == BlockPos.field_177992_a) {
            return;
        }
        this.removeEntity(position);
        this.func_76185_a();
    }

    public synchronized void connectionChanged(@Nonnull BlockPos position1, @Nonnull BlockPos position2) {
        if (position1 == BlockPos.field_177992_a || position2 == BlockPos.field_177992_a) {
            return;
        }
        this.networkChanged(position1, position2);
        this.func_76185_a();
    }

    public void func_76184_a(@Nonnull CompoundNBT compoundNBT) {
        ListNBT capabilityList = compoundNBT.func_150295_c("capabilities", compoundNBT.func_74762_e("listType"));
        int version = compoundNBT.func_74762_e("version");
        this.ENTITIES.clear();
        this.CAPABILITIES.clear();
        if (this.setup.version != version) {
            return;
        }
        capabilityList.forEach(tag -> {
            if (tag instanceof CompoundNBT) {
                CompoundNBT compound = (CompoundNBT)tag;
                int capacity = compound.func_74762_e("capacity");
                FluidTank tank = new FluidTank(capacity);
                LazyOptional capability = LazyOptional.of(() -> tank);
                HashSet set = new HashSet();
                ListNBT entitiesList = compound.func_150295_c("entities", compound.func_74762_e("listType"));
                tank.readFromNBT(compound);
                entitiesList.forEach(t -> {
                    if (t instanceof CompoundNBT) {
                        CompoundNBT c = (CompoundNBT)t;
                        int x = c.func_74762_e("x");
                        int y = c.func_74762_e("y");
                        int z = c.func_74762_e("z");
                        BlockPos pos = new BlockPos(x, y, z);
                        set.add(pos);
                        this.ENTITIES.put(pos, (LazyOptional<FluidTank>)capability);
                    }
                });
                this.CAPABILITIES.put((LazyOptional<FluidTank>)capability, set);
            }
        });
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compoundNBT) {
        ListNBT list = new ListNBT();
        this.CAPABILITIES.forEach((capability, posSet) -> {
            CompoundNBT compound = new CompoundNBT();
            ListNBT set = new ListNBT();
            capability.ifPresent(tank -> {
                compound.func_74768_a("capacity", tank.getCapacity());
                tank.writeToNBT(compound);
            });
            posSet.forEach(pos -> {
                CompoundNBT c = new CompoundNBT();
                c.func_74768_a("x", pos.func_177958_n());
                c.func_74768_a("y", pos.func_177956_o());
                c.func_74768_a("z", pos.func_177952_p());
                set.add((Object)c);
            });
            compound.func_218657_a("entities", (INBT)set);
            compound.func_74768_a("listType", (int)set.func_74732_a());
            list.add((Object)compound);
        });
        compoundNBT.func_74768_a("version", this.setup.version);
        compoundNBT.func_218657_a("capabilities", (INBT)list);
        compoundNBT.func_74768_a("listType", (int)list.func_74732_a());
        return compoundNBT;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull BlockPos position) {
        if (this.ENTITIES.containsKey(position)) {
            this.func_76185_a();
            return this.ENTITIES.get(position).cast();
        }
        return LazyOptional.empty();
    }

    private void registerEntity(@Nonnull BlockPos position) {
        List<LazyOptional<FluidTank>> around = this.findNetworksAround(position);
        if (around.isEmpty()) {
            LazyOptional<FluidTank> capability = this.getNewCapability();
            this.ENTITIES.put(position, capability);
            this.CAPABILITIES.put(capability, Sets.newHashSet((Object[])new BlockPos[]{position}));
        } else if (around.size() == 1) {
            LazyOptional<FluidTank> capability = around.get(0);
            this.ENTITIES.put(position, capability);
            this.CAPABILITIES.get(capability).add(position);
            capability.ifPresent(tank -> tank.setCapacity(tank.getCapacity() + this.setup.entityCapacity));
        } else {
            LinkedList toRemove = new LinkedList();
            LazyOptional<FluidTank> capability = around.remove(0);
            capability.ifPresent(tank -> around.forEach(c -> {
                if (c == capability) {
                    return;
                }
                c.ifPresent(t -> {
                    tank.setCapacity(tank.getCapacity() + t.getCapacity() + this.setup.entityCapacity);
                    if (!t.isEmpty()) {
                        tank.fill(t.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    }
                });
                Set<BlockPos> posSet = this.CAPABILITIES.get(c);
                this.CAPABILITIES.get(capability).addAll(posSet);
                posSet.forEach(p -> this.ENTITIES.replace((BlockPos)p, capability));
                toRemove.add(c);
            }));
            this.ENTITIES.put(position, capability);
            this.CAPABILITIES.get(capability).add(position);
            toRemove.forEach(this.CAPABILITIES::remove);
        }
    }

    private void removeEntity(@Nonnull BlockPos position) {
        Set<BlockPos> around = this.findEntitiesAround(position);
        if (around.size() == 0) {
            LazyOptional<FluidTank> capability = this.ENTITIES.remove(position);
            this.CAPABILITIES.remove(capability);
        } else if (around.size() == 1) {
            LazyOptional<FluidTank> capability = this.ENTITIES.remove(position);
            Set<BlockPos> set = this.CAPABILITIES.get(capability);
            capability.ifPresent(tank -> {
                if (!tank.isEmpty()) {
                    tank.drain(tank.getFluidAmount() / set.size(), IFluidHandler.FluidAction.EXECUTE);
                }
                tank.setCapacity(tank.getCapacity() - this.setup.entityCapacity);
            });
            set.remove(position);
        } else {
            LazyOptional<FluidTank> capability = this.ENTITIES.remove(position);
            Set<BlockPos> set = this.CAPABILITIES.remove(capability);
            capability.ifPresent(tank -> {
                if (!tank.isEmpty()) {
                    tank.drain(tank.getFluidAmount() / set.size(), IFluidHandler.FluidAction.EXECUTE);
                }
                tank.setCapacity(tank.getCapacity() - this.setup.entityCapacity);
            });
            this.recalculateNetwork(capability, around);
        }
    }

    private void recalculateNetwork(LazyOptional<FluidTank> capability, Set<BlockPos> around) {
        HashMap<BlockPos, Set> map = new HashMap<BlockPos, Set>();
        AtomicInteger oldCapacity = new AtomicInteger();
        AtomicReference oldFluid = new AtomicReference();
        capability.ifPresent(tank -> {
            oldCapacity.set(tank.getCapacity());
            oldFluid.set(tank.getFluid().copy());
        });
        int oldEntitiesCount = oldCapacity.get() / this.setup.entityCapacity;
        around.forEach(posAround -> {
            HashSet<BlockPos> mapSet = new HashSet<BlockPos>();
            map.put((BlockPos)posAround, mapSet);
            this.searchBranch((BlockPos)posAround, (Set<BlockPos>)mapSet);
        });
        Map.Entry entry = map.entrySet().iterator().next();
        int entitiesCount = ((Set)entry.getValue()).size();
        map.remove(entry.getKey());
        this.CAPABILITIES.put(capability, (Set<BlockPos>)entry.getValue());
        capability.ifPresent(tank -> {
            tank.setCapacity(entitiesCount * this.setup.entityCapacity);
            if (!((FluidStack)oldFluid.get()).isEmpty()) {
                tank.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldEntitiesCount * entitiesCount);
            }
        });
        map.forEach((pos, set) -> {
            if (set.equals(entry.getValue())) {
                return;
            }
            LazyOptional<FluidTank> newCapability = this.getNewCapability();
            this.CAPABILITIES.put(newCapability, (Set<BlockPos>)set);
            set.forEach(p -> this.ENTITIES.replace((BlockPos)p, newCapability));
            int pCount = set.size();
            newCapability.ifPresent(tank -> {
                tank.setCapacity(pCount * this.setup.entityCapacity);
                if (!((FluidStack)oldFluid.get()).isEmpty()) {
                    tank.setFluid((FluidStack)oldFluid.get());
                    tank.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldEntitiesCount * pCount);
                }
            });
        });
    }

    private void networkChanged(BlockPos position1, BlockPos position2) {
        LazyOptional<FluidTank> capability1 = this.ENTITIES.get(position1);
        LazyOptional<FluidTank> capability2 = this.ENTITIES.get(position2);
        HashSet<BlockPos> mapSet1 = new HashSet<BlockPos>();
        HashSet<BlockPos> mapSet2 = new HashSet<BlockPos>();
        if (capability1 == null || capability2 == null) {
            return;
        }
        this.searchBranch(position1, mapSet1);
        this.searchBranch(position2, mapSet2);
        if (mapSet1.equals(mapSet2) && capability1 != capability2) {
            Set<BlockPos> set2 = this.CAPABILITIES.remove(capability2);
            capability1.ifPresent(tank1 -> capability2.ifPresent(tank2 -> {
                tank1.setCapacity(tank1.getCapacity() + tank2.getCapacity());
                if (!tank1.getFluid().isEmpty() || !tank2.getFluid().isEmpty()) {
                    if (tank1.getFluid().isEmpty() && !tank2.getFluid().isEmpty()) {
                        tank1.setFluid(tank2.getFluid());
                    } else if (!tank1.getFluid().isEmpty() && !tank2.getFluid().isEmpty()) {
                        tank1.getFluid().setAmount(tank1.getFluidAmount() + tank2.getFluidAmount());
                    }
                }
            }));
            this.CAPABILITIES.get(capability1).addAll(set2);
            set2.forEach(pos -> this.ENTITIES.replace((BlockPos)pos, capability1));
        } else if (!mapSet1.equals(mapSet2) && capability1 == capability2) {
            LazyOptional<FluidTank> tmpCapability = this.getNewCapability();
            AtomicReference oldFluid = new AtomicReference();
            AtomicInteger oldCapacity = new AtomicInteger();
            capability1.ifPresent(tank1 -> {
                oldCapacity.set(tank1.getCapacity());
                oldFluid.set(tank1.getFluid());
                tank1.setCapacity(mapSet1.size() * this.setup.entityCapacity);
                if (!tank1.getFluid().isEmpty()) {
                    tank1.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldCapacity.get() * (mapSet1.size() * this.setup.entityCapacity));
                }
            });
            tmpCapability.ifPresent(tank2 -> {
                tank2.setCapacity(mapSet2.size() * this.setup.entityCapacity);
                if (!((FluidStack)oldFluid.get()).isEmpty()) {
                    tank2.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldCapacity.get() * (mapSet2.size() * this.setup.entityCapacity));
                }
            });
            this.CAPABILITIES.get(capability1).clear();
            this.CAPABILITIES.get(capability1).addAll(mapSet1);
            this.CAPABILITIES.put(tmpCapability, mapSet2);
            mapSet2.forEach(pos -> this.ENTITIES.replace((BlockPos)pos, tmpCapability));
        }
    }

    private void searchBranch(BlockPos pos, Set<BlockPos> map) {
        map.add(pos);
        this.findUniqueEntitiesAround(pos, map).forEach(posAround -> this.searchBranch((BlockPos)posAround, map));
    }

    @Nonnull
    private LazyOptional<FluidTank> getNewCapability() {
        return LazyOptional.of(() -> new FluidTank(this.setup.entityCapacity)).cast();
    }

    @Nonnull
    private List<LazyOptional<FluidTank>> findNetworksAround(@Nonnull BlockPos pos) {
        return this.setup.directions.stream().map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).filter(this.ENTITIES::containsKey).map(this.ENTITIES::get).distinct().collect(Collectors.toList());
    }

    @Nonnull
    private Set<BlockPos> findEntitiesAround(@Nonnull BlockPos pos) {
        return this.setup.directions.stream().map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).filter(this.ENTITIES::containsKey).collect(Collectors.toSet());
    }

    private Set<BlockPos> findUniqueEntitiesAround(@Nonnull BlockPos pos, @Nonnull Set<BlockPos> map) {
        return this.setup.directions.stream().map(dir -> new Pair(dir, (Object)pos.func_177972_a(dir))).filter(pair -> this.ENTITIES.containsKey(pair.getSecond())).filter(pair -> !map.contains(pair.getSecond())).filter(pair -> this.setup.checkConnection(this.world, pos, (Direction)pair.getFirst(), (BlockPos)pair.getSecond())).map(Pair::getSecond).collect(Collectors.toSet());
    }

    public static abstract class Setup {
        private final int entityCapacity;
        private final String networkId;
        private final Set<Direction> directions;
        private final int version;

        public Setup(int capacity, String id, Set<Direction> directions, int version) {
            this.entityCapacity = capacity;
            this.networkId = id;
            this.directions = directions;
            this.version = version;
        }

        public abstract boolean checkConnection(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull Direction var3, @Nonnull BlockPos var4);
    }
}

