/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.capability.kinetic;

import com.mojang.datafixers.util.Pair;
import com.yanny.ages.api.capability.kinetic.IKinetic;
import com.yanny.ages.api.capability.kinetic.IKineticGenerator;
import com.yanny.ages.api.capability.kinetic.IKineticSpindle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KineticEnergyHandler
extends WorldSavedData {
    private static final Logger LOGGER = LogManager.getLogger(KineticEnergyHandler.class);
    private final HashSet<BlockPos> REGISTRY_GENERATOR = new HashSet();
    private final HashSet<BlockPos> REGISTRY_SPINDLE = new HashSet();
    private final HashMap<BlockPos, BlockPos> CACHE_GENERATOR_FOR_SPINDLE = new HashMap();
    private final HashMap<BlockPos, HashSet<BlockPos>> CACHE_SPINDLES_FOR_GENERATOR = new HashMap();
    private final List<BlockPos> tmpList = new ArrayList<BlockPos>();
    private final World world;
    private static final String SAVE_DATA_ID = "ages_api_kinetic_energy_handler";
    private static final HashMap<World, KineticEnergyHandler> INSTANCE = new HashMap();

    private KineticEnergyHandler(@Nonnull World world) {
        super(SAVE_DATA_ID);
        this.world = world;
    }

    public static KineticEnergyHandler getInstance(@Nonnull World world) {
        if (world.field_72995_K) {
            throw new IllegalStateException("KineticEnergyHandler is only server-side");
        }
        KineticEnergyHandler handler = INSTANCE.get(world);
        if (handler == null) {
            handler = new KineticEnergyHandler(world);
            INSTANCE.put(world, handler);
        }
        if (world instanceof ServerWorld) {
            ServerWorld server = (ServerWorld)world;
            server.func_217481_x().func_215752_a(() -> INSTANCE.get(world), SAVE_DATA_ID);
        }
        return handler;
    }

    public synchronized void register(@Nonnull BlockPos position, @Nonnull IKinetic entity) {
        if (position == BlockPos.field_177992_a) {
            return;
        }
        if (entity instanceof IKineticGenerator && !this.REGISTRY_GENERATOR.contains(position)) {
            this.registerGenerator(position, (IKineticGenerator)entity);
        }
        if (entity instanceof IKineticSpindle && !this.REGISTRY_SPINDLE.contains(position)) {
            this.registerSpindle(position, (IKineticSpindle)entity);
        }
        this.func_76185_a();
    }

    public synchronized void remove(@Nonnull BlockPos position) {
        boolean hasGenerator = this.REGISTRY_GENERATOR.remove(position);
        boolean hasSpindle = this.REGISTRY_SPINDLE.remove(position);
        if (hasSpindle) {
            this.removeSpindle(position);
        }
        if (hasGenerator) {
            this.removeGenerator(position);
        }
        this.func_76185_a();
    }

    public synchronized void notifyEnergyChanged(@Nonnull BlockPos generatorPosition) {
        HashSet<BlockPos> spindles = this.CACHE_SPINDLES_FOR_GENERATOR.get(generatorPosition);
        IKineticGenerator generator = (IKineticGenerator)this.getTileEntity(this.REGISTRY_GENERATOR, generatorPosition);
        if (generator == null) {
            LOGGER.error("notifyEnergyChanged: TileEntity at {} in world {} does not exists!", (Object)generatorPosition, (Object)this.world);
            return;
        }
        spindles.forEach(blockPos -> {
            IKineticSpindle spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, (BlockPos)blockPos);
            if (spindle == null) {
                LOGGER.error("notifyEnergyChanged: TileEntity at {} in world {} does not exists!", blockPos, (Object)this.world);
                return;
            }
            spindle.onEnergyChanged(generator);
        });
    }

    public void func_76184_a(@Nonnull CompoundNBT tag) {
        CompoundNBT genTag = (CompoundNBT)tag.func_74781_a("generators");
        CompoundNBT spiTag = (CompoundNBT)tag.func_74781_a("spindles");
        CompoundNBT cacheGenTag = (CompoundNBT)tag.func_74781_a("cacheGenerator");
        CompoundNBT cacheSpiTag = (CompoundNBT)tag.func_74781_a("cacheSpindle");
        if (genTag == null || spiTag == null || cacheSpiTag == null || cacheGenTag == null) {
            return;
        }
        this.REGISTRY_GENERATOR.clear();
        this.REGISTRY_SPINDLE.clear();
        this.CACHE_SPINDLES_FOR_GENERATOR.clear();
        this.CACHE_GENERATOR_FOR_SPINDLE.clear();
        KineticEnergyHandler.readMap(genTag, this.REGISTRY_GENERATOR);
        KineticEnergyHandler.readMap(spiTag, this.REGISTRY_SPINDLE);
        KineticEnergyHandler.readMapMap(cacheGenTag, this.CACHE_SPINDLES_FOR_GENERATOR);
        KineticEnergyHandler.readMap(cacheSpiTag, this.CACHE_GENERATOR_FOR_SPINDLE);
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        CompoundNBT genTag = new CompoundNBT();
        CompoundNBT spiTag = new CompoundNBT();
        CompoundNBT cacheGenTag = new CompoundNBT();
        CompoundNBT cacheSpiTag = new CompoundNBT();
        KineticEnergyHandler.writeMap(genTag, this.REGISTRY_GENERATOR);
        KineticEnergyHandler.writeMap(spiTag, this.REGISTRY_SPINDLE);
        KineticEnergyHandler.writeMapMap(cacheGenTag, this.CACHE_SPINDLES_FOR_GENERATOR);
        KineticEnergyHandler.writeMap(cacheSpiTag, this.CACHE_GENERATOR_FOR_SPINDLE);
        compound.func_218657_a("generators", (INBT)genTag);
        compound.func_218657_a("spindles", (INBT)spiTag);
        compound.func_218657_a("cacheGenerator", (INBT)cacheGenTag);
        compound.func_218657_a("cacheSpindle", (INBT)cacheSpiTag);
        return compound;
    }

    private void registerGenerator(@Nonnull BlockPos generatorPosition, @Nonnull IKineticGenerator generator) {
        Direction direction = generator.getDirection();
        if (direction == null) {
            LogManager.getLogger().error("NULL direction");
            return;
        }
        this.REGISTRY_GENERATOR.add(generatorPosition);
        this.CACHE_SPINDLES_FOR_GENERATOR.put(generatorPosition, new HashSet());
        this.cacheSpindlesForGenerator(generatorPosition, generator, direction);
        this.cacheSpindlesForGenerator(generatorPosition, generator, direction.func_176734_d());
    }

    private void cacheSpindlesForGenerator(@Nonnull BlockPos generatorPosition, @Nonnull IKineticGenerator generator, @Nonnull Direction direction) {
        BlockPos spindlePosition;
        IKineticSpindle spindle;
        for (int i = 0; i < 8 && (spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, spindlePosition = generatorPosition.func_177967_a(direction, i + 1))) != null && KineticEnergyHandler.hasSameDirection(spindle, direction); ++i) {
            this.cacheSpindle(generatorPosition, spindlePosition, generator, spindle);
        }
    }

    private void cacheSpindle(@Nonnull BlockPos generatorPosition, @Nonnull BlockPos spindlePosition, @Nonnull IKineticGenerator generator, @Nonnull IKineticSpindle spindle) {
        if (this.CACHE_GENERATOR_FOR_SPINDLE.containsKey(spindlePosition)) {
            return;
        }
        HashSet<BlockPos> spindles = this.CACHE_SPINDLES_FOR_GENERATOR.get(generatorPosition);
        spindles.add(spindlePosition);
        this.CACHE_GENERATOR_FOR_SPINDLE.put(spindlePosition, generatorPosition);
        spindle.onConnectedToGenerator(generator);
    }

    private void registerSpindle(@Nonnull BlockPos spindlePosition, @Nonnull IKineticSpindle spindle) {
        Direction direction = spindle.getDirection();
        if (direction == null) {
            LogManager.getLogger().error("NULL direction");
            return;
        }
        this.REGISTRY_SPINDLE.add(spindlePosition);
        this.cacheGeneratorsForSpindle(spindlePosition, spindle, direction);
    }

    private void cacheGeneratorsForSpindle(@Nonnull BlockPos spindlePosition, @Nonnull IKineticSpindle spindle, @Nonnull Direction direction) {
        Pair<IKineticGenerator, BlockPos> generator = this.cacheGeneratorsInDirection(spindlePosition, direction);
        if (generator == null) {
            generator = this.cacheGeneratorsInDirection(spindlePosition, direction.func_176734_d());
        }
        if (generator != null) {
            this.cacheSpindle((BlockPos)generator.getSecond(), spindlePosition, (IKineticGenerator)generator.getFirst(), spindle);
        }
    }

    private Pair<IKineticGenerator, BlockPos> cacheGeneratorsInDirection(@Nonnull BlockPos position, @Nonnull Direction direction) {
        int distToGenerator = 0;
        for (int i = 0; i < 8; ++i) {
            BlockPos generatorPosition = position.func_177967_a(direction, i + 1);
            IKineticGenerator generator = (IKineticGenerator)this.getTileEntity(this.REGISTRY_GENERATOR, generatorPosition);
            if (generator != null && KineticEnergyHandler.hasSameDirection(generator, direction)) {
                if (8 - distToGenerator - 1 > 0) {
                    BlockPos spindlePosition;
                    IKineticSpindle spindle;
                    for (int j = 0; j < 8 - distToGenerator - 1 && (spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, spindlePosition = position.func_177967_a(direction, -1 - j))) != null; ++j) {
                        this.cacheSpindle(generatorPosition, spindlePosition, generator, spindle);
                    }
                }
                return new Pair((Object)generator, (Object)generatorPosition);
            }
            IKineticSpindle spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, generatorPosition);
            if (spindle == null || !KineticEnergyHandler.hasSameDirection(spindle, direction)) break;
            ++distToGenerator;
        }
        return null;
    }

    private void removeSpindle(@Nonnull BlockPos spindlePosition) {
        this.uncacheSpindle(spindlePosition);
        Direction.Plane.HORIZONTAL.forEach(direction -> this.uncacheSpindleInDirection(spindlePosition, (Direction)direction));
    }

    private void uncacheSpindle(@Nonnull BlockPos spindlePosition) {
        BlockPos generatorPosition = this.CACHE_GENERATOR_FOR_SPINDLE.remove(spindlePosition);
        if (generatorPosition != null) {
            HashSet<BlockPos> spindles = this.CACHE_SPINDLES_FOR_GENERATOR.get(generatorPosition);
            spindles.remove(spindlePosition);
            IKineticSpindle spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, spindlePosition);
            if (spindle != null) {
                spindle.onDisconnectFromGenerator();
            }
        }
    }

    private void uncacheSpindleInDirection(@Nonnull BlockPos position, @Nonnull Direction direction) {
        int i;
        int distToGenerator = 0;
        boolean hasGenerator = false;
        this.tmpList.clear();
        for (i = 0; i < 16; ++i) {
            BlockPos tmpPos = position.func_177967_a(direction, i + 1);
            IKineticGenerator generator = (IKineticGenerator)this.getTileEntity(this.REGISTRY_GENERATOR, tmpPos);
            IKineticSpindle spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, tmpPos);
            if (generator != null && KineticEnergyHandler.hasSameDirection(generator, direction)) {
                hasGenerator = true;
                break;
            }
            if (spindle == null || !KineticEnergyHandler.hasSameDirection(spindle, direction)) break;
            this.tmpList.add(tmpPos);
            ++distToGenerator;
        }
        if (hasGenerator && distToGenerator - 8 > 0) {
            for (i = 0; i < distToGenerator - 8; ++i) {
                this.uncacheSpindle(position.func_177967_a(direction, i + 1));
            }
        }
        if (!hasGenerator && !this.tmpList.isEmpty()) {
            this.tmpList.forEach(this::uncacheSpindle);
        }
    }

    private void removeGenerator(@Nonnull BlockPos generatorPosition) {
        HashSet<BlockPos> spindles = this.CACHE_SPINDLES_FOR_GENERATOR.remove(generatorPosition);
        spindles.forEach(spindlePosition -> {
            IKineticSpindle spindle = (IKineticSpindle)this.getTileEntity(this.REGISTRY_SPINDLE, (BlockPos)spindlePosition);
            this.CACHE_GENERATOR_FOR_SPINDLE.remove(spindlePosition);
            if (spindle == null) {
                LogManager.getLogger().error("removeGenerator: TileEntity at {} in world {} does not exists!", spindlePosition, (Object)this.world);
                return;
            }
            spindle.onDisconnectFromGenerator();
        });
    }

    @Nullable
    private <T extends IKinetic> T getTileEntity(@Nonnull HashSet<BlockPos> map, @Nonnull BlockPos position) {
        IKinetic kinetic = null;
        if (map.contains(position) && (kinetic = (IKinetic)this.world.func_175625_s(position)) == null) {
            LogManager.getLogger().error("getTileEntity: TileEntity at {} in world {} does not exists!", (Object)position, (Object)this.world);
        }
        return (T)kinetic;
    }

    private static void writeMap(@Nonnull CompoundNBT tag, @Nonnull HashSet<BlockPos> map) {
        AtomicInteger index = new AtomicInteger();
        map.forEach(blockPos -> {
            CompoundNBT tmp = new CompoundNBT();
            tmp.func_74768_a("x", blockPos.func_177958_n());
            tmp.func_74768_a("y", blockPos.func_177956_o());
            tmp.func_74768_a("z", blockPos.func_177952_p());
            tag.func_218657_a("pos" + index.getAndIncrement(), (INBT)tmp);
        });
    }

    private static void writeMap(@Nonnull CompoundNBT tag, @Nonnull HashMap<BlockPos, BlockPos> map) {
        AtomicInteger index = new AtomicInteger();
        map.forEach((pos1, pos2) -> {
            CompoundNBT tmp = new CompoundNBT();
            tmp.func_74768_a("x1", pos1.func_177958_n());
            tmp.func_74768_a("y1", pos1.func_177956_o());
            tmp.func_74768_a("z1", pos1.func_177952_p());
            tmp.func_74768_a("x2", pos2.func_177958_n());
            tmp.func_74768_a("y2", pos2.func_177956_o());
            tmp.func_74768_a("z2", pos2.func_177952_p());
            tag.func_218657_a("pos" + index.getAndIncrement(), (INBT)tmp);
        });
    }

    private static void writeMapMap(@Nonnull CompoundNBT tag, @Nonnull HashMap<BlockPos, HashSet<BlockPos>> map) {
        AtomicInteger index = new AtomicInteger();
        map.forEach((position, spindles) -> {
            CompoundNBT tmp = new CompoundNBT();
            CompoundNBT tmpMap = new CompoundNBT();
            tmp.func_74768_a("x", position.func_177958_n());
            tmp.func_74768_a("y", position.func_177956_o());
            tmp.func_74768_a("z", position.func_177952_p());
            KineticEnergyHandler.writeMap(tmpMap, spindles);
            tmp.func_218657_a("map", (INBT)tmpMap);
            tag.func_218657_a("pos" + index.getAndIncrement(), (INBT)tmp);
        });
    }

    private static void readMap(@Nonnull CompoundNBT tag, @Nonnull HashSet<BlockPos> map) {
        CompoundNBT data;
        int index = 0;
        while ((data = (CompoundNBT)tag.func_74781_a("pos" + index++)) != null) {
            int x = data.func_74762_e("x");
            int y = data.func_74762_e("y");
            int z = data.func_74762_e("z");
            map.add(new BlockPos(x, y, z));
        }
    }

    private static void readMap(@Nonnull CompoundNBT tag, @Nonnull HashMap<BlockPos, BlockPos> map) {
        CompoundNBT data;
        int index = 0;
        while ((data = (CompoundNBT)tag.func_74781_a("pos" + index++)) != null) {
            int x1 = data.func_74762_e("x1");
            int y1 = data.func_74762_e("y1");
            int z1 = data.func_74762_e("z1");
            int x2 = data.func_74762_e("x2");
            int y2 = data.func_74762_e("y2");
            int z2 = data.func_74762_e("z2");
            map.put(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
        }
    }

    private static void readMapMap(@Nonnull CompoundNBT tag, @Nonnull HashMap<BlockPos, HashSet<BlockPos>> map) {
        CompoundNBT data;
        int index = 0;
        while ((data = (CompoundNBT)tag.func_74781_a("pos" + index++)) != null) {
            int x = data.func_74762_e("x");
            int y = data.func_74762_e("y");
            int z = data.func_74762_e("z");
            HashSet<BlockPos> spindles = new HashSet<BlockPos>();
            KineticEnergyHandler.readMap(data.func_74775_l("map"), spindles);
            map.put(new BlockPos(x, y, z), spindles);
        }
    }

    private static boolean hasSameDirection(@Nonnull IKineticGenerator generator, @Nonnull Direction direction) {
        if (generator.getDirection() == null) {
            return false;
        }
        return generator.getDirection() == direction || generator.getDirection().func_176734_d() == direction;
    }

    private static boolean hasSameDirection(@Nonnull IKineticSpindle generator, @Nonnull Direction direction) {
        if (generator.getDirection() == null) {
            return false;
        }
        return generator.getDirection() == direction || generator.getDirection().func_176734_d() == direction;
    }
}

