/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.items;

import com.google.common.collect.Sets;
import com.yanny.ages.api.items.AgesToolItem;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AgesShovelItem
extends AgesToolItem {
    private static final Set<Block> EFFECTIVE_ON = (Set)AgesShovelItem.getPrivateValue(ShovelItem.class, null, 0);
    private static final Map<Block, BlockState> SHOVEL_LOOKUP = (Map)AgesShovelItem.getPrivateValue(ShovelItem.class, null, 1);
    private static final Set<Material> EFFECTIVE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151597_y, Material.field_151596_z});

    public AgesShovelItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder, true, true, true);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return EFFECTIVE_MATERIALS.contains(blockIn.func_185904_a());
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        PlayerEntity playerentity = context.func_195999_j();
        BlockState effectiveBlockState = SHOVEL_LOOKUP.get(blockstate.func_177230_c());
        BlockState effective = null;
        if (effectiveBlockState != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            effective = effectiveBlockState;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            world.func_217378_a(null, 1009, blockpos, 0);
            effective = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.FALSE);
        }
        if (effective != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, effective, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

