/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.items;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AgesToolItem
extends TieredItem {
    private final Set<Block> effectiveBlocks;
    private final boolean displayAttackDamage;
    private final boolean displayAttackSpeed;
    private final boolean displayEfficiency;
    protected float efficiency;
    protected float attackDamage;
    protected float attackSpeed;

    public AgesToolItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties builder, boolean displayAttackDamage, boolean displayAttackSpeed, boolean displayEfficiency) {
        super(tier, builder);
        this.effectiveBlocks = effectiveBlocksIn;
        this.efficiency = tier.func_200928_b();
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        this.displayAttackDamage = displayAttackDamage;
        this.displayAttackSpeed = displayAttackSpeed;
        this.displayEfficiency = displayEfficiency;
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
            return this.efficiency + AgesToolItem.getAdditionalEfficiency(stack);
        }
        return this.effectiveBlocks.contains(state.func_177230_c()) ? this.efficiency + AgesToolItem.getAdditionalEfficiency(stack) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        stack.func_222118_a(2, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, World worldIn, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ImmutableMultimap.Builder attributeModifierBuilder = ImmutableMultimap.builder();
        attributeModifierBuilder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(this.attackDamage + AgesToolItem.getAdditionalAttackDamage(stack)), AttributeModifier.Operation.ADDITION));
        attributeModifierBuilder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)(this.attackSpeed + AgesToolItem.getAdditionalAttackSpeed(stack)), AttributeModifier.Operation.ADDITION));
        return attributeModifierBuilder.build();
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77973_b() instanceof AgesToolItem) {
            float efficiency;
            float attackSpeed;
            float attackDamage;
            if (this.displayAttackDamage && (double)Math.abs(attackDamage = AgesToolItem.getAdditionalAttackDamage(stack)) > 0.01) {
                tooltip.add((ITextComponent)new StringTextComponent("Attack damage: ").func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%.2f", Float.valueOf(attackDamage))).func_240699_a_(attackDamage >= 0.0f ? TextFormatting.GREEN : TextFormatting.RED)));
            }
            if (this.displayAttackSpeed && (double)Math.abs(attackSpeed = AgesToolItem.getAdditionalAttackSpeed(stack)) > 0.01) {
                tooltip.add((ITextComponent)new StringTextComponent("Attack speed: ").func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%.2f", Float.valueOf(attackSpeed))).func_240699_a_(attackSpeed >= 0.0f ? TextFormatting.GREEN : TextFormatting.RED)));
            }
            if (this.displayEfficiency && (double)Math.abs(efficiency = AgesToolItem.getAdditionalEfficiency(stack)) > 0.01) {
                tooltip.add((ITextComponent)new StringTextComponent("Efficiency: ").func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%.2f", Float.valueOf(efficiency))).func_240699_a_(efficiency >= 0.0f ? TextFormatting.GREEN : TextFormatting.RED)));
            }
        }
    }

    public static float getAdditionalAttackDamage(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        return tag.func_74760_g("attackDamage");
    }

    public static float getAdditionalAttackSpeed(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        return tag.func_74760_g("attackSpeed");
    }

    public static float getAdditionalEfficiency(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        return tag.func_74760_g("efficiency");
    }

    public static void setAdditionalModifiers(ItemStack itemStack, float attackDamage, float attackSpeed, float efficiency) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        tag.func_74776_a("attackDamage", attackDamage);
        tag.func_74776_a("attackSpeed", attackSpeed);
        tag.func_74776_a("efficiency", efficiency);
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

