/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.google.common.collect.Maps;
import com.yanny.age.stone.blocks.AqueductBlock;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.handlers.AqueductHandler;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AqueductTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final float LEVELS = 20.0f;
    private static final FluidStack WATER = new FluidStack((Fluid)Fluids.field_204546_a, 0);
    private final Map<Direction, Boolean> sources = Maps.newHashMap();
    private boolean activated = false;
    private boolean initialized = false;
    private float capacity = 0.0f;
    private int level = 0;
    private int filled = 0;
    private int fullCapacity = 0;

    public AqueductTileEntity() {
        super(TileEntitySubscriber.aqueduct);
        this.sources.put(Direction.NORTH, false);
        this.sources.put(Direction.SOUTH, false);
        this.sources.put(Direction.EAST, false);
        this.sources.put(Direction.WEST, false);
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (!this.initialized) {
            this.initialized = true;
            HorizontalBlock.field_185512_D.func_177700_c().forEach(direction -> {
                BlockPos pos = this.func_174877_v().func_177972_a(direction);
                this.setSource((Direction)direction, AqueductBlock.isWater(this.field_145850_b.func_180495_p(pos).func_177230_c(), this.field_145850_b.func_204610_c(pos)));
            });
        }
        if (!this.field_145850_b.field_72995_K) {
            LazyOptional fluidTank = AqueductHandler.getInstance(this.field_145850_b).getCapability(this.field_174879_c);
            fluidTank.ifPresent(tank -> {
                int oldLevel = this.level;
                this.filled = tank.getFluidAmount();
                this.fullCapacity = tank.getCapacity();
                this.level = Math.round((float)tank.getFluidAmount() / (float)tank.getCapacity() * 20.0f);
                if (oldLevel != this.level) {
                    this.capacity = (float)this.level / 20.0f;
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                }
                LazyOptional upperTank = AqueductHandler.getInstance(this.field_145850_b).getCapability(this.field_174879_c.func_177984_a());
                if (this.sources.containsValue(true)) {
                    this.activated = false;
                    WATER.setAmount(Config.aqueductFillPerTick);
                    tank.fill(WATER, IFluidHandler.FluidAction.EXECUTE);
                } else if (upperTank.isPresent()) {
                    upperTank.ifPresent(upTank -> {
                        this.activated = false;
                        if (tank.getSpace() >= Config.aqueductFillPerTick) {
                            tank.fill(upTank.drain(Config.aqueductFillPerTick, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                        }
                    });
                } else if (this.activated) {
                    FluidStack fluidStack = tank.drain(Config.aqueductUsePerTick, IFluidHandler.FluidAction.EXECUTE);
                    if (fluidStack.isEmpty()) {
                        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                        }
                    } else {
                        if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)));
                        }
                        if (this.field_145850_b.field_73012_v.nextInt(Config.aqueductTickChanceBoneMealEffect) == 0) {
                            AqueductTileEntity.boneMealEffect(this.field_174879_c, (ServerWorld)this.field_145850_b);
                        }
                    }
                } else if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                }
            });
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return AqueductHandler.getInstance(this.field_145850_b).getCapability(this.field_174879_c);
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(@Nonnull BlockState blockState, CompoundNBT tag) {
        this.capacity = tag.func_74760_g("capacity");
        this.activated = tag.func_74767_n("activated");
        super.func_230337_a_(blockState, tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74776_a("capacity", this.capacity);
        tag.func_74757_a("activated", this.activated);
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            AqueductHandler.getInstance(this.field_145850_b).register(this.field_174879_c);
        }
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            AqueductHandler.getInstance(this.field_145850_b).remove(this.field_174879_c);
        }
        super.func_145843_s();
    }

    public float getCapacity() {
        return this.capacity;
    }

    public int getFilled() {
        return this.filled;
    }

    public int getFullCapacity() {
        return this.fullCapacity;
    }

    void setSource(@Nonnull Direction direction, boolean isSource) {
        this.sources.replace(direction, isSource);
    }

    void changedState() {
        assert (this.field_145850_b != null);
        this.activated = !this.activated;
    }

    private static void boneMealEffect(@Nonnull BlockPos pos, @Nonnull ServerWorld world) {
        IGrowable igrowable;
        int r = Config.aqueductEffectRange;
        BlockPos cropPos = pos.func_177984_a().func_177964_d(world.field_73012_v.nextInt(r * 2 + 1) - r).func_177965_g(world.field_73012_v.nextInt(r * 2 + 1) - r);
        BlockState blockstate = world.func_180495_p(cropPos);
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)world, cropPos, blockstate, world.field_72995_K) && igrowable.func_180670_a((World)world, world.field_73012_v, cropPos, blockstate)) {
            igrowable.func_225535_a_(world, world.field_73012_v, cropPos, blockstate);
            world.func_217379_c(2005, cropPos, 0);
            for (int i = 0; i < 5; ++i) {
                double d0 = world.field_73012_v.nextGaussian() * 0.02;
                double d1 = world.field_73012_v.nextGaussian() * 0.02;
                double d2 = world.field_73012_v.nextGaussian() * 0.02;
                world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)cropPos.func_177958_n() + world.field_73012_v.nextFloat()), (double)cropPos.func_177956_o() + (double)world.field_73012_v.nextFloat() * blockstate.func_196954_c((IBlockReader)world, cropPos).func_197758_c(Direction.Axis.Y), (double)((float)cropPos.func_177952_p() + world.field_73012_v.nextFloat()), d0, d1, d2);
            }
        }
    }
}

