/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.FeederContainer;
import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class FeederTileEntity
extends TileEntity
implements IInventoryInterface,
ITickableTileEntity,
INamedContainerProvider {
    private static final Set<Item> VALID_ITEMS = new HashSet<Item>();
    public static final int ITEMS = 4;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> sidedInventoryHandler = LazyOptional.of(() -> this.createSidedInventoryHandler(this.stacks));
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private AxisAlignedBB boundingBox = new AxisAlignedBB(this.func_174877_v());

    public FeederTileEntity() {
        super(TileEntitySubscriber.feeder);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(Config.feederTickChanceBreedAnimalEffect) == 0 && this.getItem().isPresent()) {
            this.useOnEntity();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity entity) {
        assert (this.field_145850_b != null);
        return new FeederContainer(id, this.field_174879_c, this.field_145850_b, inventory, entity);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        assert (this.func_200662_C().getRegistryName() != null);
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    public void func_230337_a_(@Nonnull BlockState blockState, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        super.func_230337_a_(blockState, tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                if (side != Direction.UP) {
                    return this.sidedInventoryHandler.cast();
                }
            } else {
                return this.nonSidedInventoryHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.boundingBox = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - Config.feederEffectRange), (double)(this.field_174879_c.func_177956_o() - 1), (double)(this.field_174879_c.func_177952_p() - Config.feederEffectRange), (double)(this.field_174879_c.func_177958_n() + Config.feederEffectRange + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + Config.feederEffectRange + 1));
    }

    public void func_145843_s() {
        this.sidedInventoryHandler.invalidate();
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    boolean isItemValid(@Nonnull ItemStack itemStack) {
        return VALID_ITEMS.contains(itemStack.func_77973_b());
    }

    @Nonnull
    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (FeederTileEntity.this.isItemValid(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (FeederTileEntity.this.field_145850_b != null);
                FeederTileEntity.this.func_70296_d();
                FeederTileEntity.this.field_145850_b.func_184138_a(FeederTileEntity.this.func_174877_v(), FeederTileEntity.this.func_195044_w(), FeederTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    @Nonnull
    private IItemHandlerModifiable createSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (FeederTileEntity.this.isItemValid(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (FeederTileEntity.this.field_145850_b != null);
                FeederTileEntity.this.func_70296_d();
                FeederTileEntity.this.field_145850_b.func_184138_a(FeederTileEntity.this.func_174877_v(), FeederTileEntity.this.func_195044_w(), FeederTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    @Nonnull
    private Optional<ItemStack> getItem() {
        return this.stacks.stream().filter(itemStack -> !itemStack.func_190926_b()).findFirst();
    }

    private void useOnEntity() {
        assert (this.field_145850_b != null);
        List entities = this.field_145850_b.func_175647_a(AnimalEntity.class, this.boundingBox, AgeableEntity::func_213743_em);
        Collections.shuffle(entities);
        if (!entities.isEmpty()) {
            this.getItem().ifPresent(itemStack -> {
                AnimalEntity winner = (AnimalEntity)entities.get(0);
                if (winner.func_70631_g_()) {
                    winner.func_175501_a((int)((float)(-winner.func_70874_b() / 20) * 0.1f), true);
                    itemStack.func_190918_g(1);
                } else {
                    List entities1 = this.field_145850_b.func_175647_a(winner.getClass(), this.boundingBox, livingEntity -> !livingEntity.func_70028_i((Entity)winner) && !livingEntity.func_70631_g_() && livingEntity.func_213743_em());
                    if (winner.func_70874_b() == 0 && entities1.size() < 30) {
                        winner.func_146082_f(null);
                        itemStack.func_190918_g(1);
                        this.getItem().ifPresent(itemStack1 -> {
                            if (!entities1.isEmpty()) {
                                Collections.shuffle(entities1);
                                AnimalEntity winner1 = (AnimalEntity)entities1.get(0);
                                if (winner1.func_70874_b() == 0 && winner1.func_213743_em()) {
                                    winner1.func_146082_f(null);
                                    itemStack1.func_190918_g(1);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    static {
        VALID_ITEMS.addAll(Tags.Items.SEEDS.func_230236_b_());
        VALID_ITEMS.addAll(Tags.Items.CROPS.func_230236_b_());
    }
}

