/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.yanny.age.stone.blocks.FlintWorkbenchTileEntity;
import com.yanny.ages.api.utils.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlintWorkbenchRenderer
extends TileEntityRenderer<FlintWorkbenchTileEntity> {
    public FlintWorkbenchRenderer(@Nonnull TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(@Nonnull FlintWorkbenchTileEntity tileEntity, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer renderTypeBuffer, int overlayUV, int lightmapUV) {
        Direction direction = (Direction)tileEntity.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D);
        float border = 0.0625f;
        float part = (1.0f - 4.0f * border) / 3.0f;
        float t = border + part / 2.0f;
        float off = part + border;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x = 0;
                int y = 0;
                switch (direction) {
                    case NORTH: {
                        x = 2 - j;
                        y = 2 - i;
                        break;
                    }
                    case SOUTH: {
                        x = j;
                        y = i;
                        break;
                    }
                    case WEST: {
                        x = 2 - i;
                        y = j;
                        break;
                    }
                    case EAST: {
                        x = i;
                        y = 2 - j;
                    }
                }
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(off * (float)x + t), 0.125, (double)(off * (float)y + t));
                switch (direction) {
                    case SOUTH: {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                        break;
                    }
                    case WEST: {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                        break;
                    }
                    case EAST: {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                    }
                }
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(tileEntity.getInventory().func_70301_a(i * 3 + j), ItemCameraTransforms.TransformType.FIXED, overlayUV, lightmapUV, matrixStack, renderTypeBuffer);
                matrixStack.func_227865_b_();
            }
        }
        if (!tileEntity.getRecipeOutput().func_190926_b()) {
            matrixStack.func_227860_a_();
            switch (direction) {
                case NORTH: {
                    matrixStack.func_227861_a_(0.5, (double)0.4f, (double)0.95f);
                    break;
                }
                case SOUTH: {
                    matrixStack.func_227861_a_(0.5, (double)0.4f, (double)0.05f);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    break;
                }
                case WEST: {
                    matrixStack.func_227861_a_((double)0.95f, (double)0.4f, 0.5);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    break;
                }
                case EAST: {
                    matrixStack.func_227861_a_((double)0.05f, (double)0.4f, 0.5);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                }
            }
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            ItemStackUtils.renderItem((ItemStack)tileEntity.getRecipeOutput(), (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED, (int)overlayUV, (int)lightmapUV, (MatrixStack)matrixStack, (IRenderTypeBuffer)renderTypeBuffer, (float)0.6f);
            matrixStack.func_227865_b_();
        }
    }
}

