/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.yanny.age.stone.client.models.FowlModel;
import com.yanny.age.stone.entities.FowlEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class FowlRenderer
extends MobRenderer<FowlEntity, FowlModel> {
    private static final ResourceLocation FOWL_TEXTURE = new ResourceLocation("stone_age", "textures/entity/fowl.png");

    private FowlRenderer(@Nonnull EntityRendererManager rendererManager) {
        super(rendererManager, (EntityModel)new FowlModel(), 0.3f);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull FowlEntity entity) {
        return FOWL_TEXTURE;
    }

    protected float handleRotationFloat(FowlEntity livingBase, float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.wingRotation);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.destPos);
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected boolean canRenderName(FowlEntity entity) {
        return entity.func_145818_k_();
    }

    public static class RenderFactory
    implements IRenderFactory<FowlEntity> {
        public EntityRenderer<? super FowlEntity> createRenderFor(EntityRendererManager manager) {
            return new FowlRenderer(manager);
        }
    }
}

