/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.yanny.age.stone.blocks.StoneChestBlock;
import com.yanny.age.stone.blocks.StoneChestTileEntity;
import com.yanny.age.stone.client.models.StoneChestModel;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StoneChestRenderer
extends TileEntityRenderer<StoneChestTileEntity> {
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("stone_age", "textures/entity/stone_chest.png");
    private final StoneChestModel model = new StoneChestModel();

    public StoneChestRenderer(@Nonnull TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(@Nonnull StoneChestTileEntity tileEntity, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer renderTypeBuffer, int overlayUV, int lightmapUV) {
        BlockState blockstate = tileEntity.func_145830_o() ? tileEntity.func_195044_w() : (BlockState)BlockSubscriber.stone_chest.func_176223_P().func_206870_a((Property)StoneChestBlock.field_185512_D, (Comparable)Direction.SOUTH);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.0, 1.0);
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        float f = ((Direction)blockstate.func_177229_b((Property)StoneChestBlock.field_185512_D)).func_185119_l();
        if ((double)Math.abs(f) > 1.0E-5) {
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        }
        matrixStack.func_227861_a_(0.5, -0.5, 0.5);
        this.applyLidRotation(tileEntity, partialTicks, this.model);
        this.model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)TEXTURE_NORMAL)), overlayUV, lightmapUV, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    private void applyLidRotation(@Nonnull StoneChestTileEntity tileEntity, float angle, @Nonnull StoneChestModel model) {
        float f = tileEntity.func_195480_a(angle);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        model.getLid().field_78796_g = -(f * 1.5707964f);
    }
}

