/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.entities;

import com.yanny.age.stone.compatibility.top.TopEntityInfoProvider;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.entities.AgroTargetGoal;
import com.yanny.age.stone.entities.RaidFarmGoal;
import com.yanny.age.stone.entities.TargetAggressorGoal;
import com.yanny.age.stone.entities.WildAnimalEntity;
import com.yanny.age.stone.subscribers.EntitySubscriber;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class FowlEntity
extends WildAnimalEntity
implements TopEntityInfoProvider {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    private float wingRotDelta = 1.0f;

    public FowlEntity(@Nonnull EntityType<? extends FowlEntity> type, @Nonnull World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    @Nonnull
    public AgeableEntity func_241840_a(@Nonnull ServerWorld serverWorld, @Nonnull AgeableEntity ageable) {
        if (Math.min((Integer)this.field_70180_af.func_187225_a(GENERATION), (Integer)ageable.func_184212_Q().func_187225_a(GENERATION)) >= Config.domesticateAfterGenerations) {
            EntityType child = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(Config.fowlBreedingResult));
            if (child != null) {
                Entity result = child.func_200721_a(this.field_70170_p);
                if (result instanceof AgeableEntity) {
                    return (AgeableEntity)child.func_200721_a(this.field_70170_p);
                }
                field_184243_a.warn("'{}' is not instance of Ageable entity! Spawning default CHICKEN entity", (Object)Config.fowlBreedingResult);
            } else {
                field_184243_a.warn("'{}' does not exists! Spawning default CHICKEN entity", (Object)Config.fowlBreedingResult);
            }
            return (AgeableEntity)EntityType.field_200795_i.func_200721_a(this.field_70170_p);
        }
        FowlEntity entity = (FowlEntity)EntitySubscriber.fowl.func_200721_a(this.field_70170_p);
        if (entity != null) {
            entity.setGeneration((Integer)this.field_70180_af.func_187225_a(GENERATION) + 1);
        }
        return entity;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(5, new RaidFarmGoal<FowlEntity>(this, CropsBlock.class, CropsBlock.field_176488_a));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AgroTargetGoal((CreatureEntity)this, FowlEntity.class, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new TargetAggressorGoal<FowlEntity>(this, FowlEntity.class));
    }

    private static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public static void registerCustomAttributes() {
        GlobalEntityTypeAttributes.put(EntitySubscriber.fowl, (AttributeModifierMap)FowlEntity.getAttributes().func_233813_a_());
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184185_a(SoundEvents.field_187666_Z, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        Vector3d vec3d = this.func_213322_ci();
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    @Override
    public void addProbeInfo(@Nonnull ProbeMode mode, @Nonnull IProbeInfo probeInfo, @Nonnull PlayerEntity player, @Nonnull World world, @Nonnull Entity entity, @Nonnull IProbeHitEntityData data) {
        probeInfo.horizontal().text(ITextComponent.func_244388_a((String)("Generation: " + this.field_70180_af.func_187225_a(GENERATION))));
    }
}

