/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.recipes;

import com.yanny.age.stone.subscribers.RecipeSubscriber;
import com.yanny.ages.api.items.AgesPartItem;
import com.yanny.ages.api.items.AgesToolItem;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlintWorkbenchRecipe
implements IRecipe<IInventory> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IRecipeType<FlintWorkbenchRecipe> flint_workbench = IRecipeType.func_222147_a((String)"stone_age:flint_workbench");
    public static final int MAX_WIDTH = 3;
    public static final int MAX_HEIGHT = 3;
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final String group;
    private final Ingredient tool;

    public FlintWorkbenchRecipe(@Nonnull ResourceLocation id, @Nonnull String group, int recipeWidth, int recipeHeight, @Nonnull Ingredient tool, @Nonnull NonNullList<Ingredient> ingredients, @Nonnull ItemStack output) {
        this.id = id;
        this.group = group;
        this.recipeWidth = recipeWidth;
        this.recipeHeight = recipeHeight;
        this.recipeItems = ingredients;
        this.recipeOutput = output;
        this.tool = tool;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSubscriber.flint_workbench;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return flint_workbench;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public boolean func_77569_a(@Nonnull IInventory inv, @Nonnull World worldIn) {
        for (int x = 0; x <= 3 - this.recipeWidth; ++x) {
            for (int y = 0; y <= 3 - this.recipeHeight; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inv) {
        ItemStack result = this.func_77571_b().func_77946_l();
        if (result.func_77973_b() instanceof AgesPartItem) {
            AgesPartItem item = (AgesPartItem)result.func_77973_b();
            item.applyStats(result);
        } else if (result.func_77973_b() instanceof AgesToolItem) {
            ItemStack part = null;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (!(itemStack.func_77973_b() instanceof AgesPartItem)) continue;
                part = itemStack;
            }
            if (part != null) {
                AgesToolItem.setAdditionalModifiers((ItemStack)result, (float)AgesToolItem.getAdditionalAttackDamage(part), (float)AgesToolItem.getAdditionalAttackSpeed(part), (float)AgesToolItem.getAdditionalEfficiency(part));
            } else {
                LOGGER.warn("Expected item with AgesToolItem parent '{}' recipe", (Object)this.recipeOutput.func_200301_q());
            }
        }
        return result;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    private boolean checkMatch(@Nonnull IInventory inventory, int dx, int dy, boolean reversed) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int x1 = x - dx;
                int y1 = y - dy;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (x1 >= 0 && y1 >= 0 && x1 < this.recipeWidth && y1 < this.recipeHeight) {
                    ingredient = reversed ? (Ingredient)this.recipeItems.get(this.recipeWidth - x1 - 1 + y1 * this.recipeWidth) : (Ingredient)this.recipeItems.get(x1 + y1 * this.recipeWidth);
                }
                if (ingredient.test(inventory.func_70301_a(x + y * 3))) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public Ingredient getTool() {
        return this.tool;
    }
}

