/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.yanny.age.stone.recipes.MillstoneRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MillstoneRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<MillstoneRecipe> {
    private final IFactory<MillstoneRecipe> factory;

    public MillstoneRecipeSerializer(@Nonnull IFactory<MillstoneRecipe> factory) {
        this.factory = factory;
    }

    @Nonnull
    public MillstoneRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ItemStack result;
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = NBTIngredient.func_199802_a((JsonElement)jsonelement);
        ItemStack secondResult = ItemStack.field_190927_a;
        int activateCount = JSONUtils.func_151208_a((JsonObject)json, (String)"activateCount", (int)1);
        double secondChance = JSONUtils.func_151221_a((JsonObject)json, (String)"secondChance", (float)1.0f);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resourcelocation));
        }
        if (json.has("secondResult")) {
            if (json.get("secondResult").isJsonObject()) {
                secondResult = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"secondResult"), (boolean)true);
            } else {
                String string = JSONUtils.func_151200_h((JsonObject)json, (String)"secondResult");
                ResourceLocation resourceLocation = new ResourceLocation(string);
                secondResult = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resourceLocation));
            }
        } else {
            secondChance = 0.0;
        }
        return this.factory.create(recipeId, group, ingredient, result, secondResult, secondChance, activateCount);
    }

    @Nullable
    public MillstoneRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack result = buffer.func_150791_c();
        ItemStack secondResult = buffer.func_150791_c();
        double secondChance = buffer.readDouble();
        int activateCount = buffer.readInt();
        return this.factory.create(recipeId, group, ingredient, result, secondResult, secondChance, activateCount);
    }

    public void write(PacketBuffer buffer, MillstoneRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        recipe.ingredient.func_199564_a(buffer);
        buffer.func_150788_a(recipe.result);
        buffer.func_150788_a(recipe.secondResult);
        buffer.writeDouble(recipe.secondChance);
        buffer.writeInt(recipe.activateCount);
    }

    public static interface IFactory<T extends MillstoneRecipe> {
        public T create(@Nonnull ResourceLocation var1, @Nonnull String var2, @Nonnull Ingredient var3, @Nonnull ItemStack var4, @Nonnull ItemStack var5, double var6, int var8);
    }
}

