/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.subscribers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.entities.SaberToothTigerEntity;
import com.yanny.age.stone.subscribers.EntitySubscriber;
import com.yanny.age.stone.subscribers.FeatureSubscriber;
import com.yanny.age.stone.subscribers.ItemSubscriber;
import com.yanny.ages.api.enums.Age;
import com.yanny.ages.api.utils.AgeUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="stone_age", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    private static final String PLAYER_MANUAL_NBT = "stone_age_manual";
    private static final Set<ResourceLocation> RECIPES_TO_REMOVE = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft", "wooden_axe"), new ResourceLocation("minecraft", "wooden_pickaxe"), new ResourceLocation("minecraft", "wooden_hoe"), new ResourceLocation("minecraft", "wooden_shovel"), new ResourceLocation("minecraft", "wooden_sword"), new ResourceLocation("minecraft", "stone_axe"), new ResourceLocation("minecraft", "stone_pickaxe"), new ResourceLocation("minecraft", "stone_hoe"), new ResourceLocation("minecraft", "stone_shovel"), new ResourceLocation("minecraft", "stone_sword"), new ResourceLocation("minecraft", "torch"), new ResourceLocation("minecraft", "oak_planks"), new ResourceLocation("minecraft", "birch_planks"), new ResourceLocation("minecraft", "acacia_planks"), new ResourceLocation("minecraft", "jungle_planks"), new ResourceLocation("minecraft", "spruce_planks"), new ResourceLocation("minecraft", "dark_oak_planks"), new ResourceLocation("minecraft", "crafting_table")});
    private static final Set<ResourceLocation> RECIPES_TO_ADD = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("stone_age", "crafting_table")});
    private static final Set<ResourceLocation> ADVANCEMENTS_TO_REMOVE = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft", "recipes/tools/wooden_axe"), new ResourceLocation("minecraft", "recipes/tools/wooden_pickaxe"), new ResourceLocation("minecraft", "recipes/tools/wooden_hoe"), new ResourceLocation("minecraft", "recipes/tools/wooden_shovel"), new ResourceLocation("minecraft", "recipes/combat/wooden_sword"), new ResourceLocation("minecraft", "recipes/tools/stone_axe"), new ResourceLocation("minecraft", "recipes/tools/stone_pickaxe"), new ResourceLocation("minecraft", "recipes/tools/stone_hoe"), new ResourceLocation("minecraft", "recipes/tools/stone_shovel"), new ResourceLocation("minecraft", "recipes/combat/stone_sword"), new ResourceLocation("minecraft", "recipes/building_blocks/oak_planks"), new ResourceLocation("minecraft", "recipes/building_blocks/birch_planks"), new ResourceLocation("minecraft", "recipes/building_blocks/acacia_planks"), new ResourceLocation("minecraft", "recipes/building_blocks/jungle_planks"), new ResourceLocation("minecraft", "recipes/building_blocks/spruce_planks"), new ResourceLocation("minecraft", "recipes/building_blocks/dark_oak_planks"), new ResourceLocation("minecraft", "recipes/decorations/torch")});

    @SubscribeEvent
    public static void FMLServerStartingEvent(@Nonnull FMLServerStartingEvent event) {
        if (Config.removeVanillaRecipes) {
            RecipeManager recipeManager = event.getServer().func_199529_aN();
            Class<?> recipeManagerClass = recipeManager.getClass();
            try {
                Field recipes = recipeManagerClass.getDeclaredFields()[2];
                recipes.setAccessible(true);
                Map recipesMap = (Map)recipes.get(recipeManager);
                HashMap map = Maps.newHashMap();
                recipesMap.forEach((iRecipeType, resourceLocationIRecipeMap) -> {
                    Map map1 = map.computeIfAbsent(iRecipeType, recipeType -> Maps.newHashMap());
                    resourceLocationIRecipeMap.forEach(map1::put);
                    RECIPES_TO_REMOVE.forEach(map1::remove);
                    RECIPES_TO_ADD.forEach(resourceLocation -> {
                        IRecipe recipe = (IRecipe)map1.remove(resourceLocation);
                        if (recipe != null) {
                            map1.put(new ResourceLocation("minecraft", resourceLocation.func_110623_a()), recipe);
                        }
                    });
                });
                recipes.set(recipeManager, ImmutableMap.copyOf((Map)map));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            AdvancementManager advancementManager = event.getServer().func_191949_aK();
            Class<?> advancementManagerClass = advancementManager.getClass();
            Field advancements = advancementManagerClass.getDeclaredFields()[2];
            advancements.setAccessible(true);
            try {
                AdvancementList advancementList = (AdvancementList)advancements.get(advancementManager);
                Class<?> list = advancementList.getClass();
                Field listField = list.getDeclaredFields()[1];
                listField.setAccessible(true);
                Map map = (Map)listField.get(advancementList);
                ADVANCEMENTS_TO_REMOVE.forEach(map::remove);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (Config.forceToolForWood) {
            ForgeEventSubscriber.setUseToolForWood();
        }
    }

    @SubscribeEvent
    public static void entitySpawnEvent(@Nonnull EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof SheepEntity) {
            SheepEntity sheepEntity = (SheepEntity)entity;
            sheepEntity.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)sheepEntity, SaberToothTigerEntity.class, 14.0f, 1.5, 2.2));
        }
        if (entity instanceof ChickenEntity) {
            ChickenEntity chickenEntity = (ChickenEntity)entity;
            chickenEntity.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)chickenEntity, SaberToothTigerEntity.class, 14.0f, 1.5, 2.2));
        }
    }

    @SubscribeEvent
    public static void rightClickBlockEvent(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockPos = event.getPos();
        BlockState blockState = event.getWorld().func_180495_p(blockPos);
        if (Config.disableVanillaCraftingTable && blockState.func_177230_c() == Blocks.field_150462_ai && AgeUtils.getPlayerAge((PlayerEntity)event.getPlayer()) <= Age.STONE_AGE.value) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void rightClickMillstone(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockPos = event.getPos();
        TileEntity tileEntity = event.getWorld().func_175625_s(blockPos);
        if (tileEntity instanceof INamedContainerProvider && !event.getWorld().field_72995_K && event.getPlayer().func_225608_bj_()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)event.getPlayer()), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
        }
    }

    @SubscribeEvent
    public static void advancementEvent(@Nonnull AdvancementEvent event) {
        if (event.getAdvancement().func_192067_g().equals((Object)new ResourceLocation("stone_age", "stone_age/end_of_stone_age")) && AgeUtils.getPlayerAge((PlayerEntity)event.getPlayer()) <= Age.STONE_AGE.value) {
            AgeUtils.setPlayerAge((PlayerEntity)event.getPlayer(), (Age)Age.BRONZE_AGE);
        }
    }

    @SubscribeEvent
    public static void litTorch(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.MAIN_HAND && player.func_184614_ca().func_77973_b().equals(ItemSubscriber.unlit_torch)) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockPos facePos = event.getPos().func_177972_a(event.getFace());
            BlockState blockState = world.func_180495_p(pos);
            BlockState faceBlockState = world.func_180495_p(facePos);
            if (blockState.func_177230_c().equals(Blocks.field_222433_lV) || faceBlockState.func_177230_c().equals(Blocks.field_150480_ab) || blockState.func_177230_c().equals(Blocks.field_150478_aa)) {
                player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_221657_bQ, player.func_184614_ca().func_190916_E()));
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void makeFireWithSticksAndDriedGrass(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack mainItem = player.func_184614_ca();
        ItemStack offItem = player.func_184592_cb();
        if (mainItem.func_77973_b() == Items.field_151055_y && offItem.func_77973_b() == Items.field_151055_y && event.getFace() != null) {
            World world = event.getWorld();
            BlockPos position = event.getPos().func_177972_a(event.getFace());
            BlockState blockState = world.func_180495_p(position);
            List driedGrassList = world.func_175647_a(ItemEntity.class, new AxisAlignedBB(position), itemEntity -> itemEntity.func_92059_d().func_77973_b().equals(ItemSubscriber.dried_grass));
            if (blockState.func_177230_c().isAir(blockState, (IBlockReader)world, position) && !driedGrassList.isEmpty()) {
                world.func_180501_a(position, Blocks.field_150480_ab.func_176223_P(), 11);
                player.func_213334_d(Hand.MAIN_HAND);
                player.func_213334_d(Hand.OFF_HAND);
                if (mainItem.func_190916_E() > 1) {
                    mainItem.func_190920_e(mainItem.func_190916_E() - 1);
                } else {
                    player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
                if (offItem.func_190916_E() > 1) {
                    offItem.func_190920_e(offItem.func_190916_E() - 1);
                } else {
                    player.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
                }
                driedGrassList.forEach(Entity::func_70106_y);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void biomeLoadingEventAdd(@Nonnull BiomeLoadingEvent event) {
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (Config.spawnDeerEnable && !Config.spawnDeerAllowedBiomesBlacklist == Config.spawnDeerAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.deer.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.deer, Config.spawnDeerWeight, Config.spawnDeerMinCount, Config.spawnDeerMaxCount));
        }
        if (Config.spawnBoarEnable && !Config.spawnBoarAllowedBiomesBlacklist == Config.spawnBoarAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.boar.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.boar, Config.spawnBoarWeight, Config.spawnBoarMinCount, Config.spawnBoarMaxCount));
        }
        if (Config.spawnAurochEnable && !Config.spawnAurochAllowedBiomesBlacklist == Config.spawnAurochAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.auroch.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.auroch, Config.spawnAurochWeight, Config.spawnAurochMinCount, Config.spawnAurochMaxCount));
        }
        if (Config.spawnFowlEnable && !Config.spawnFowlAllowedBiomesBlacklist == Config.spawnFowlAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.fowl.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.fowl, Config.spawnFowlWeight, Config.spawnFowlMinCount, Config.spawnFowlMaxCount));
        }
        if (Config.spawnMouflonEnable && !Config.spawnMouflonAllowedBiomesBlacklist == Config.spawnMouflonAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.mouflon.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.mouflon, Config.spawnMouflonWeight, Config.spawnMouflonMinCount, Config.spawnMouflonMaxCount));
        }
        if (Config.spawnMammothEnable && !Config.spawnMammothAllowedBiomesBlacklist == Config.spawnMammothAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.mammoth.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.mammoth, Config.spawnMammothWeight, Config.spawnMammothMinCount, Config.spawnMammothMaxCount));
        }
        if (Config.spawnSaberToothTigerEnable && !Config.spawnSaberToothTigerAllowedBiomesBlacklist == Config.spawnSaberToothTigerAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.saber_tooth_tiger.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.saber_tooth_tiger, Config.spawnSaberToothTigerWeight, Config.spawnSaberToothTigerMinCount, Config.spawnSaberToothTigerMaxCount));
        }
        if (Config.spawnWoollyRhinoEnable && !Config.spawnWoollyRhinoAllowedBiomesBlacklist == Config.spawnWoollyRhinoAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            spawns.getSpawner(EntitySubscriber.woolly_rhino.func_220339_d()).add(new MobSpawnInfo.Spawners(EntitySubscriber.woolly_rhino, Config.spawnWoollyRhinoWeight, Config.spawnWoollyRhinoMinCount, Config.spawnWoollyRhinoMaxCount));
        }
        if (Config.abandonedCampAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> FeatureSubscriber.abandoned_camp_feature.func_225566_b_((IFeatureConfig)new ProbabilityConfig((float)Config.abandonedCampSpawnChance)).func_227228_a_(Features.Placements.field_244001_l));
        }
        if (Config.burialPlaceAllowedBiomes.stream().anyMatch(biome -> ForgeEventSubscriber.biomeComparator(biome, event))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> FeatureSubscriber.burial_place_feature.func_225566_b_((IFeatureConfig)new ProbabilityConfig((float)Config.burialPlaceSpawnChance)).func_227228_a_(Features.Placements.field_244001_l));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void biomeLoadingEventRemove(@Nonnull BiomeLoadingEvent event) {
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (Config.removeVanillaGeneratedAnimals) {
            HashSet vanillaEntities = Sets.newHashSet((Object[])new EntityType[]{EntityType.field_200796_j, EntityType.field_200737_ac, EntityType.field_200784_X, EntityType.field_200795_i});
            spawns.getSpawner(EntityClassification.CREATURE).removeIf(entry -> vanillaEntities.contains(entry.field_242588_c));
        }
    }

    @SubscribeEvent
    public static void axeHarvestCheck(@Nonnull PlayerEvent.HarvestCheck event) {
        BlockState state = event.getTargetBlock();
        PlayerEntity entity = event.getPlayer();
        ItemStack stack = entity.func_184586_b(Hand.MAIN_HAND);
        Item item = stack.func_77973_b();
        if (entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof AxeItem && state.func_185904_a() == Material.field_151575_d && state.func_177230_c().getHarvestLevel(state) <= item.getHarvestLevel(stack, ToolType.AXE, entity, state)) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public static void addManualToPlayer(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        CompoundNBT persistent;
        if (!Config.givePlayerManualOnFirstConnect) {
            return;
        }
        CompoundNBT nbt = event.getPlayer().getPersistentData();
        if (!nbt.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            nbt.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = nbt.func_74775_l("PlayerPersisted");
        }
        if (!persistent.func_74764_b(PLAYER_MANUAL_NBT)) {
            persistent.func_74757_a(PLAYER_MANUAL_NBT, true);
            ItemStack book = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book")));
            if (!book.func_190926_b()) {
                book.func_196082_o().func_74778_a("patchouli:book", "stone_age:stone_tablet");
                event.getPlayer().field_71071_by.func_70441_a(book);
            }
        }
    }

    private static boolean biomeComparator(Biome biome, BiomeLoadingEvent event) {
        if (biome.getRegistryName() != null) {
            return biome.getRegistryName().compareTo(event.getName()) == 0;
        }
        return false;
    }

    private static void setUseToolForWood() {
        Field useTool = ObfuscationReflectionHelper.findField(AbstractBlock.AbstractBlockState.class, (String)"field_235706_j_");
        Field material = AbstractBlock.class.getDeclaredFields()[1];
        useTool.setAccessible(true);
        material.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(useTool, useTool.getModifiers() & 0xFFFFFFEF);
            ForgeRegistries.BLOCKS.forEach(block -> {
                try {
                    if (material.get(block).equals(Material.field_151575_d)) {
                        useTool.setBoolean(block.func_176223_P(), true);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

