/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.client.renderer.entity;

import com.commodorethrawn.strawgolem.client.renderer.entity.model.ModelStrawGolem;
import com.commodorethrawn.strawgolem.config.ConfigHelper;
import com.commodorethrawn.strawgolem.entity.EntityStrawGolem;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class RenderStrawGolem
extends MobRenderer<EntityStrawGolem, ModelStrawGolem<EntityStrawGolem>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("strawgolem", "textures/entity/straw_golem.png");
    private static final ResourceLocation TEXTURE_OLD = new ResourceLocation("strawgolem", "textures/entity/old_straw_golem.png");
    private static final ResourceLocation TEXTURE_DYING = new ResourceLocation("strawgolem", "textures/entity/dying_straw_golem.png");

    public RenderStrawGolem(EntityRendererManager rendermanagerIn) {
        super(rendermanagerIn, new ModelStrawGolem(), 0.5f);
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
    }

    public void doRender(EntityStrawGolem entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
        ModelStrawGolem golem = (ModelStrawGolem)this.func_217764_d();
        golem.setStatus(!entityIn.isHandEmpty(), entityIn.holdingFullBlock());
        Biome b = entityIn.field_70170_p.func_180494_b(entityIn.func_180425_c());
        if (ConfigHelper.isShiverEnabled() && ((double)b.func_180626_a(entityIn.func_180425_c()) < 0.15 || entityIn.func_209511_p())) {
            float offX = entityIn.func_70681_au().nextFloat() / 32.0f - 0.015625f;
            float offZ = entityIn.func_70681_au().nextFloat() / 32.0f - 0.015625f;
            GlStateManager.translatef((float)offX, (float)0.0f, (float)offZ);
        }
        super.func_76986_a((MobEntity)entityIn, x, y, z, entityYaw, partialTicks);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(EntityStrawGolem golem) {
        if (golem.getCurrentLifespan() * 4 < ConfigHelper.getLifespan()) {
            return TEXTURE_DYING;
        }
        if (golem.getCurrentLifespan() * 2 < ConfigHelper.getLifespan()) {
            return TEXTURE_OLD;
        }
        return TEXTURE;
    }
}

