/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.entity;

import com.commodorethrawn.strawgolem.Registry;
import com.commodorethrawn.strawgolem.config.ConfigHelper;
import com.commodorethrawn.strawgolem.entity.ai.GolemDeliverGoal;
import com.commodorethrawn.strawgolem.entity.ai.GolemFleeGoal;
import com.commodorethrawn.strawgolem.entity.ai.GolemHarvestGoal;
import com.commodorethrawn.strawgolem.entity.ai.GolemLookAtPlayerGoal;
import com.commodorethrawn.strawgolem.entity.ai.GolemLookRandomlyGoal;
import com.commodorethrawn.strawgolem.entity.ai.GolemTemptGoal;
import com.commodorethrawn.strawgolem.entity.ai.GolemWanderGoal;
import com.commodorethrawn.strawgolem.entity.capability.InventoryProvider;
import com.commodorethrawn.strawgolem.entity.capability.lifespan.ILifespan;
import com.commodorethrawn.strawgolem.entity.capability.lifespan.LifespanProvider;
import com.commodorethrawn.strawgolem.entity.capability.memory.IMemory;
import com.commodorethrawn.strawgolem.entity.capability.memory.MemoryProvider;
import com.commodorethrawn.strawgolem.entity.capability.profession.IProfession;
import com.commodorethrawn.strawgolem.entity.capability.profession.ProfessionProvider;
import com.commodorethrawn.strawgolem.network.MessageLifespan;
import com.commodorethrawn.strawgolem.network.PacketHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;

public class EntityStrawGolem
extends GolemEntity {
    public static final SoundEvent GOLEM_AMBIENT = new SoundEvent(new ResourceLocation("strawgolem", "golem_ambient"));
    public static final SoundEvent GOLEM_STRAINED = new SoundEvent(new ResourceLocation("strawgolem", "golem_strained"));
    public static final SoundEvent GOLEM_HURT = new SoundEvent(new ResourceLocation("strawgolem", "golem_hurt"));
    public static final SoundEvent GOLEM_DEATH = new SoundEvent(new ResourceLocation("strawgolem", "golem_death"));
    public static final SoundEvent GOLEM_HEAL = new SoundEvent(new ResourceLocation("strawgolem", "golem_heal"));
    public static final SoundEvent GOLEM_SCARED = new SoundEvent(new ResourceLocation("strawgolem", "golem_scared"));
    public static final SoundEvent GOLEM_INTERESTED = new SoundEvent(new ResourceLocation("strawgolem", "golem_interested"));
    private static final ResourceLocation LOOT = new ResourceLocation("strawgolem", "strawgolem");
    private final ILifespan lifespan;
    private final IMemory memory;
    private final IProfession profession;
    private static final String BAD_CAP = "Can't be empty";
    private BlockPos harvestPos;
    private final IItemHandler inventory = (IItemHandler)this.getCapability(InventoryProvider.CROP_SLOT, null).orElseThrow(() -> new IllegalArgumentException(BAD_CAP));

    public EntityStrawGolem(EntityType<? extends EntityStrawGolem> type, World worldIn) {
        super(type, worldIn);
        this.profession = (IProfession)this.getCapability(ProfessionProvider.PROFESSION_CAP, null).orElseThrow(() -> new IllegalArgumentException(BAD_CAP));
        this.lifespan = (ILifespan)this.getCapability(LifespanProvider.LIFESPAN_CAP, null).orElseThrow(() -> new IllegalArgumentException(BAD_CAP));
        this.memory = (IMemory)this.getCapability(MemoryProvider.MEMORY_CAP, null).orElseThrow(() -> new IllegalArgumentException(BAD_CAP));
        this.harvestPos = BlockPos.field_177992_a;
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected SoundEvent func_184639_G() {
        if (ConfigHelper.isSoundsEnabled()) {
            if (this.field_70714_bg.func_220888_c().anyMatch(goal -> goal.func_220772_j() instanceof GolemFleeGoal)) {
                return GOLEM_SCARED;
            }
            if (this.holdingFullBlock()) {
                return GOLEM_STRAINED;
            }
            return GOLEM_AMBIENT;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return ConfigHelper.isSoundsEnabled() ? GOLEM_HURT : null;
    }

    protected SoundEvent func_184615_bR() {
        return ConfigHelper.isSoundsEnabled() ? GOLEM_DEATH : null;
    }

    public int func_70627_aG() {
        return this.holdingFullBlock() ? 60 : 120;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_184651_r() {
        int priority = 0;
        this.field_70714_bg.func_75776_a(priority, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemFleeGoal(this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemTemptGoal(this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemHarvestGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemDeliverGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemWanderGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemLookAtPlayerGoal(this, 5.0f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new GolemLookRandomlyGoal(this));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            this.lifespan.update();
            if (this.holdingFullBlock() && ConfigHelper.isLifespanPenalty("heavy")) {
                this.lifespan.update();
            }
            if (this.func_209511_p()) {
                this.lifespan.update();
            }
            if (this.field_70170_p.func_201671_F(this.func_180425_c()) && ConfigHelper.isLifespanPenalty("water")) {
                this.lifespan.update();
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MessageLifespan(this));
            }
            if (this.lifespan.isOver()) {
                this.func_70097_a(DamageSource.field_76376_m, this.func_110138_aP() * 100.0f);
            }
        } else if (this.lifespan.get() * 4 < ConfigHelper.getLifespan() && this.field_70146_Z.nextInt(80) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)Registry.FLY_PARTICLE, this.field_70142_S, this.field_70137_T, this.field_70136_U, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_209511_p() {
        return this.field_70170_p.func_175727_C(this.func_180425_c()) && this.field_70170_p.func_175710_j(this.func_180425_c()) && ConfigHelper.isLifespanPenalty("rain");
    }

    public boolean isHandEmpty() {
        return this.func_184614_ca().func_190926_b();
    }

    @Nonnull
    public ItemStack func_184586_b(@Nonnull Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return this.inventory.getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    public boolean holdingFullBlock() {
        ItemStack item = this.inventory.getStackInSlot(0);
        if (!(item.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item.func_77973_b();
        return blockItem != Items.field_190931_a && blockItem.func_179223_d().func_176223_P().func_200132_m() && blockItem.func_179223_d().func_199767_j() == blockItem;
    }

    public boolean func_98052_bS() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_213333_a(@Nonnull DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        if (EffectiveSide.get().isServer()) {
            this.func_199701_a_(this.inventory.getStackInSlot(0).func_77946_l());
            this.inventory.getStackInSlot(0).func_190920_e(0);
        }
    }

    protected boolean func_184645_a(PlayerEntity player, @Nonnull Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151015_O) {
            if (EffectiveSide.get().isServer()) {
                if (player.func_70093_af()) {
                    player.func_145747_a(new StringTextComponent("Ordering: ").func_150257_a(this.func_145748_c_()));
                    player.getPersistentData().func_74768_a("golemId", this.func_145782_y());
                } else if (this.isGolemHurt()) {
                    this.func_70606_j(this.func_110138_aP());
                    this.func_184185_a(GOLEM_HEAL, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187579_bV, 1.0f, 1.0f);
                    this.addToLifespan(12000);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageLifespan(this));
                }
            }
            if (!player.func_70093_af() && this.isGolemHurt()) {
                this.spawnHealParticles(this.field_70142_S, this.field_70137_T, this.field_70136_U);
            }
        }
        return false;
    }

    private boolean isGolemHurt() {
        return this.func_110143_aJ() != this.func_110138_aP() || (double)this.getCurrentLifespan() < (double)ConfigHelper.getLifespan() * 0.9;
    }

    private void spawnHealParticles(double x, double y, double z) {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, x + this.field_70146_Z.nextDouble() - 0.5, y + 0.4, z + this.field_70146_Z.nextDouble() - 0.5, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
    }

    public void func_70107_b(double posX, double posY, double posZ) {
        if (this.func_184218_aH() && this.func_184187_bx() instanceof IronGolemEntity) {
            IronGolemEntity ironGolem = (IronGolemEntity)this.func_184187_bx();
            double lookX = ironGolem.func_70040_Z().field_72450_a;
            double lookZ = ironGolem.func_70040_Z().field_72449_c;
            double magnitude = Math.sqrt(lookX * lookX + lookZ * lookZ);
            super.func_70107_b(posX + 1.9 * (lookX /= magnitude), posY - 0.5, posZ + 1.9 * (lookZ /= magnitude));
        } else {
            super.func_70107_b(posX, posY, posZ);
        }
    }

    public void func_184210_p() {
        LivingEntity ridingEntity = (LivingEntity)this.func_184187_bx();
        super.func_184210_p();
        if (ridingEntity instanceof IronGolemEntity) {
            double lookX = ridingEntity.func_70040_Z().field_72450_a;
            double lookZ = ridingEntity.func_70040_Z().field_72449_c;
            double magnitude = Math.sqrt(lookX * lookX + lookZ * lookZ);
            super.func_70107_b(this.func_213303_ch().field_72450_a + (lookX /= magnitude), this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c + (lookZ /= magnitude));
        }
    }

    public boolean shouldHarvestBlock(IWorldReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (ConfigHelper.blockHarvestAllowed(state.func_177230_c())) {
            if (state.func_177230_c() instanceof CropsBlock) {
                return ((CropsBlock)state.func_177230_c()).func_185525_y(state);
            }
            if (state.func_177230_c() instanceof StemGrownBlock) {
                return true;
            }
            if (state.func_177230_c() instanceof NetherWartBlock) {
                return (Integer)state.func_177229_b((IProperty)NetherWartBlock.field_176486_a) == 3;
            }
            if (state.func_177230_c() instanceof BushBlock && state.func_177230_c() instanceof IGrowable) {
                return state.func_196959_b((IProperty)BlockStateProperties.field_208168_U) && (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208168_U) == 3;
            }
        }
        return false;
    }

    public boolean canSeeBlock(IWorldReader worldIn, BlockPos pos) {
        Vec3d golemPos = this.func_213303_ch().func_72441_c(0.0, 0.75, 0.0);
        if (this.func_213303_ch().field_72448_b % 1.0 != 0.0) {
            golemPos = golemPos.func_72441_c(0.0, 0.5, 0.0);
        }
        Vec3d blockPos = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
        RayTraceContext ctx = new RayTraceContext(golemPos, blockPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this);
        return worldIn.func_217299_a(ctx).func_216350_a().func_218137_a((IPosition)blockPos, 2.5);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public IMemory getMemory() {
        return this.memory;
    }

    public void setHarvesting(BlockPos pos) {
        this.harvestPos = pos;
    }

    public BlockPos getHarvestPos() {
        return this.harvestPos;
    }

    public void clearHarvestPos() {
        this.harvestPos = BlockPos.field_177992_a;
    }

    public int getCurrentLifespan() {
        return this.lifespan.get();
    }

    public void addToLifespan(int time) {
        this.lifespan.set(this.lifespan.get() + time);
    }
}

