/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.entity.ai;

import com.commodorethrawn.strawgolem.Strawgolem;
import com.commodorethrawn.strawgolem.config.ConfigHelper;
import com.commodorethrawn.strawgolem.entity.EntityStrawGolem;
import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class GolemHarvestGoal
extends MoveToBlockGoal {
    private final EntityStrawGolem strawgolem;

    public GolemHarvestGoal(EntityStrawGolem strawgolem, double speedIn) {
        super((CreatureEntity)strawgolem, speedIn, ConfigHelper.getSearchRangeHorizontal(), ConfigHelper.getSearchRangeVertical());
        this.strawgolem = strawgolem;
    }

    public boolean func_75250_a() {
        if (this.strawgolem.isHandEmpty() && !this.strawgolem.getHarvestPos().equals((Object)BlockPos.field_177992_a)) {
            this.field_179494_b = this.strawgolem.getHarvestPos();
            this.field_179496_a = this.func_203109_a(this.field_179495_c);
            this.strawgolem.clearHarvestPos();
            return this.strawgolem.shouldHarvestBlock((IWorldReader)this.strawgolem.field_70170_p, this.field_179494_b) && this.strawgolem.canSeeBlock((IWorldReader)this.strawgolem.field_70170_p, this.field_179494_b);
        }
        if (this.field_179496_a > 0) {
            --this.field_179496_a;
            return false;
        }
        this.field_179496_a = this.func_203109_a(this.field_179495_c);
        return this.strawgolem.isHandEmpty() && this.func_179489_g() && this.strawgolem.canSeeBlock((IWorldReader)this.strawgolem.field_70170_p, this.field_179494_b);
    }

    protected int func_203109_a(@Nonnull CreatureEntity creatureIn) {
        return 360;
    }

    public boolean func_75253_b() {
        return super.func_75253_b() && !this.strawgolem.func_184218_aH();
    }

    public void func_75246_d() {
        this.strawgolem.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.strawgolem.func_70646_bf());
        double targetDistance = this.func_203110_f();
        Block destinationBlockType = this.strawgolem.field_70170_p.func_180495_p(this.field_179494_b).func_177230_c();
        if (destinationBlockType instanceof StemGrownBlock) {
            targetDistance += 0.2;
        }
        if (destinationBlockType instanceof BushBlock) {
            targetDistance += 0.55;
        }
        if (!this.field_179494_b.func_218137_a((IPosition)this.field_179495_c.func_213303_ch(), targetDistance)) {
            ++this.field_179493_e;
            if (this.func_203108_i()) {
                this.field_179495_c.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o() + 1.0, (double)this.field_179494_b.func_177952_p() + 0.5, this.field_179492_d);
            }
        } else {
            --this.field_179493_e;
            this.harvestCrop();
        }
    }

    protected boolean func_179488_a(@Nonnull IWorldReader worldIn, @Nonnull BlockPos pos) {
        return this.strawgolem.shouldHarvestBlock(worldIn, pos) && this.strawgolem.isHandEmpty();
    }

    private void harvestCrop() {
        ServerWorld worldIn = (ServerWorld)this.strawgolem.field_70170_p;
        BlockPos pos = this.field_179494_b;
        BlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (this.func_179488_a((IWorldReader)worldIn, pos)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_219625_by, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.doPickup(worldIn, pos, state, block);
            this.doReplant(worldIn, pos, state, block);
        }
    }

    private void doPickup(ServerWorld worldIn, BlockPos pos, BlockState state, Block block) {
        if (ConfigHelper.isDeliveryEnabled()) {
            if (block instanceof StemGrownBlock) {
                this.strawgolem.func_184185_a(EntityStrawGolem.GOLEM_STRAINED, 1.0f, 1.0f);
                this.strawgolem.getInventory().insertItem(0, new ItemStack((IItemProvider)Item.field_179220_a.getOrDefault(block, Items.field_190931_a)), false);
            } else if (block instanceof CropsBlock || block instanceof NetherWartBlock) {
                List drops = Block.func_220070_a((BlockState)state, (ServerWorld)worldIn, (BlockPos)pos, (TileEntity)worldIn.func_175625_s(pos));
                for (ItemStack drop : drops) {
                    if (this.isCropDrop(drop)) {
                        this.strawgolem.getInventory().insertItem(0, drop, false);
                        continue;
                    }
                    if (!(drop.func_77973_b() instanceof BlockItem) || drop.func_77973_b() instanceof BlockNamedItem) continue;
                    this.strawgolem.func_184185_a(EntityStrawGolem.GOLEM_STRAINED, 1.0f, 1.0f);
                    this.strawgolem.getInventory().insertItem(0, drop, false);
                    break;
                }
            } else {
                this.fakeRightClick(worldIn, pos, state);
            }
        }
    }

    private void doReplant(ServerWorld worldIn, BlockPos pos, BlockState state, Block block) {
        if (ConfigHelper.isReplantEnabled()) {
            if (block instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)block;
                worldIn.func_175656_a(pos, crop.func_176223_P());
            } else if (block instanceof NetherWartBlock) {
                worldIn.func_175656_a(pos, (BlockState)block.func_176223_P().func_206870_a((IProperty)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(0)));
            } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208168_U) && block instanceof BushBlock) {
                worldIn.func_175656_a(pos, (BlockState)block.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(2)));
            } else {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        worldIn.func_184138_a(pos.func_177984_a(), state, worldIn.func_180495_p(pos), 3);
    }

    private void fakeRightClick(ServerWorld worldIn, BlockPos pos, BlockState state) {
        FakePlayer fake = FakePlayerFactory.get((ServerWorld)worldIn, (GameProfile)new GameProfile(null, "golem"));
        BlockRayTraceResult result = new BlockRayTraceResult(this.strawgolem.func_213303_ch(), this.strawgolem.func_174811_aO().func_176734_d(), pos, false);
        try {
            state.func_215687_a((World)worldIn, (PlayerEntity)fake, Hand.MAIN_HAND, result);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.RightClickBlock((PlayerEntity)fake, Hand.MAIN_HAND, pos, this.strawgolem.func_174811_aO().func_176734_d()));
            List itemList = worldIn.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos).func_186662_g(2.5));
            for (ItemEntity item : itemList) {
                this.strawgolem.getInventory().insertItem(0, item.func_92059_d(), false);
                item.func_70106_y();
            }
        }
        catch (NullPointerException ex) {
            Strawgolem.logger.info(String.format("Golem could not harvest block at: %s", pos));
        }
        fake.remove(false);
    }

    private boolean isCropDrop(ItemStack drop) {
        return !(drop.func_77973_b() instanceof BlockItem) || drop.func_77975_n() == UseAction.EAT || drop.func_77973_b() == Items.field_151075_bm;
    }
}

