/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlyParticle
extends SpriteTexturedParticle {
    private float thetaHoriz;
    private float thetaVert;

    protected FlyParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
        super(worldIn, xCoordIn, yCoordIn + (double)0.4f, zCoordIn);
        this.field_187126_f += (double)(this.field_187136_p.nextFloat() - 0.5f);
        this.field_187128_h += (double)(this.field_187136_p.nextFloat() - 0.5f);
        this.func_187115_a(0.02f, 0.02f);
        this.field_70547_e = 60;
        this.thetaHoriz = this.field_187136_p.nextFloat() * (float)Math.PI;
        this.thetaVert = 0.0f;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.thetaHoriz = (float)((double)this.thetaHoriz + 0.05);
            this.thetaVert = (float)((double)this.thetaVert + 0.05);
            this.field_187129_i = Math.sin(this.thetaHoriz) / 14.0;
            this.field_187131_k = Math.cos(this.thetaHoriz) / 14.0;
            this.field_187130_j = Math.sin(2.0f * this.thetaVert) / 12.0 + 0.025;
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FlyParticle flyParticle = new FlyParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            flyParticle.func_70538_b(1.0f, 1.0f, 1.0f);
            flyParticle.func_217568_a(this.spriteSet);
            return flyParticle;
        }
    }
}

