/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.config;

import com.commodorethrawn.strawgolem.config.StrawgolemConfig;
import java.util.List;
import net.minecraft.block.Block;

public class ConfigHelper {
    public static boolean isReplantEnabled() {
        return StrawgolemConfig.replantEnabled;
    }

    public static boolean isDeliveryEnabled() {
        return StrawgolemConfig.deliveryEnabled;
    }

    public static boolean isSoundsEnabled() {
        return StrawgolemConfig.soundsEnabled;
    }

    public static boolean isShiverEnabled() {
        return StrawgolemConfig.shiverEnabled;
    }

    public static boolean isEnableHwyla() {
        return StrawgolemConfig.enableHwyla;
    }

    public static boolean doGolemPickup() {
        return StrawgolemConfig.golemInteract;
    }

    public static int getSearchRangeHorizontal() {
        return StrawgolemConfig.searchRangeHorizontal;
    }

    public static int getLifespan() {
        return StrawgolemConfig.lifespan;
    }

    public static boolean isLifespanPenalty(String penalty) {
        if (penalty.equals("rain")) {
            return StrawgolemConfig.rainPenalty;
        }
        if (penalty.equals("water")) {
            return StrawgolemConfig.waterPenalty;
        }
        if (penalty.equals("heavy")) {
            return StrawgolemConfig.heavyPenalty;
        }
        return false;
    }

    public static int getSearchRangeVertical() {
        return StrawgolemConfig.searchRangeVertical;
    }

    public static boolean blockHarvestAllowed(Block block) {
        switch (StrawgolemConfig.filterMode) {
            case "whitelist": {
                StrawgolemConfig.FilterMatch whitelistMatch = ConfigHelper.blockMatchesFilter(block, StrawgolemConfig.whitelist);
                if (whitelistMatch == StrawgolemConfig.FilterMatch.Mod) {
                    return ConfigHelper.blockMatchesFilter(block, StrawgolemConfig.blacklist) != StrawgolemConfig.FilterMatch.Exact;
                }
                return whitelistMatch != StrawgolemConfig.FilterMatch.None;
            }
            case "blacklist": {
                StrawgolemConfig.FilterMatch blacklistMatch = ConfigHelper.blockMatchesFilter(block, StrawgolemConfig.whitelist);
                if (blacklistMatch == StrawgolemConfig.FilterMatch.Mod) {
                    return ConfigHelper.blockMatchesFilter(block, StrawgolemConfig.whitelist) == StrawgolemConfig.FilterMatch.Exact;
                }
                return blacklistMatch == StrawgolemConfig.FilterMatch.None;
            }
        }
        return true;
    }

    public static StrawgolemConfig.FilterMatch blockMatchesFilter(Block block, List<? extends String> filter) {
        StrawgolemConfig.FilterMatch bestMatch = StrawgolemConfig.FilterMatch.None;
        for (String string : filter) {
            String[] elements = string.split(":");
            if (elements.length == 1 && block.getRegistryName().func_110624_b().equals(elements[0])) {
                bestMatch = StrawgolemConfig.FilterMatch.Mod;
                continue;
            }
            if (elements.length < 2 || !block.getRegistryName().func_110624_b().equals(elements[0]) || !block.getRegistryName().func_110623_a().equals(elements[1])) continue;
            bestMatch = StrawgolemConfig.FilterMatch.Exact;
            break;
        }
        return bestMatch;
    }
}

