/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.events;

import com.commodorethrawn.strawgolem.entity.EntityStrawGolem;
import com.commodorethrawn.strawgolem.network.MessageLifespan;
import com.commodorethrawn.strawgolem.network.PacketHandler;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;

@Mod.EventBusSubscriber(modid="strawgolem", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GolemEventHandler {
    private static final String GOLEM = "golemId";

    private GolemEventHandler() {
    }

    @SubscribeEvent
    public static void onGolemHurt(LivingAttackEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof EntityStrawGolem && event.getSource() == DamageSource.field_220302_v) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            List golems = player.field_70170_p.func_217357_a(EntityStrawGolem.class, player.func_174813_aQ().func_186662_g(25.0));
            for (EntityStrawGolem golem : golems) {
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageLifespan(golem));
            }
        }
    }

    @SubscribeEvent
    public static void setPriorityChest(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            EntityStrawGolem golem;
            TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
            PlayerEntity player = event.getPlayer();
            if (tileEntity != null && event.getHand() == Hand.MAIN_HAND && player.func_184614_ca().func_77973_b() == Items.field_151015_O && tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent() && player.getPersistentData().func_74764_b(GOLEM) && (golem = (EntityStrawGolem)event.getWorld().func_73045_a(player.getPersistentData().func_74762_e(GOLEM))) != null) {
                golem.getMemory().setPriorityChest(event.getPos());
                golem.getMemory().addPosition((IWorld)event.getWorld(), event.getPos());
                event.getPlayer().func_145747_a(golem.func_145748_c_().func_150258_a(" will now deliver to this chest"));
                player.getPersistentData().func_82580_o(GOLEM);
            }
        }
    }
}

