/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.config;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StrawgolemConfig {
    static final String FILTER_MODE_WHITELIST = "whitelist";
    static final String FILTER_MODE_BLACKLIST = "blacklist";
    static boolean replantEnabled;
    static boolean deliveryEnabled;
    static int searchRangeHorizontal;
    static int searchRangeVertical;
    static String filterMode;
    static List<? extends String> whitelist;
    static List<? extends String> blacklist;
    static boolean soundsEnabled;
    static boolean shiverEnabled;
    static boolean golemInteract;
    static boolean enableHwyla;
    static int lifespan;
    static boolean rainPenalty;
    static boolean waterPenalty;
    static boolean heavyPenalty;

    public static class CommonConfig {
        final ForgeConfigSpec.BooleanValue enableReplant;
        final ForgeConfigSpec.BooleanValue enableDelivery;
        final ForgeConfigSpec.IntValue lifespan;
        final ForgeConfigSpec.ConfigValue<String> filterMode;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        final ForgeConfigSpec.IntValue searchRangeHorizontal;
        final ForgeConfigSpec.IntValue searchRangeVertical;
        final ForgeConfigSpec.BooleanValue soundsEnabled;
        final ForgeConfigSpec.BooleanValue golemInteract;
        final ForgeConfigSpec.BooleanValue shiverEnabled;
        final ForgeConfigSpec.BooleanValue enableHwyla;
        final ForgeConfigSpec.BooleanValue waterPenalty;
        final ForgeConfigSpec.BooleanValue rainPenalty;
        final ForgeConfigSpec.BooleanValue heavyPenalty;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Harvesting");
            this.enableReplant = builder.comment("Allow the straw golems to replant a crop when they harvest it.").define("enableReplant", true);
            this.enableDelivery = builder.comment("Allow the straw golem to deliver a crop (requires replantEnabled = true)").define("enableDelivery", true);
            this.searchRangeHorizontal = builder.comment("Horizontal search range for crops and chests").defineInRange("searchRangeHorizontal", 12, 8, 32);
            this.searchRangeVertical = builder.comment("Vertical search range for crops and chests").defineInRange("searchRangeVertical", 3, 2, 8);
            builder.pop();
            builder.push("Filtration");
            this.filterMode = builder.comment(new String[]{"Sets the method for applying harvest filters.  Note that only the most specific match will be taken into consideration.", "If a crop's mod appears in the whitelist, but the crop itself is in the blacklist, the crop will be banned.", "Likewise if a crop's mod appears in the blacklist, but the crop itself is in the whitelist, the crop will be allowed.", "\"none\": allow all crops to be harvested (default).", "\"whitelist\": will deny crops from being harvested unless the most specific match is in the whitelist.", "\"blacklist\": will allows crops to be harvested unless the most specific match is in the blacklist."}).define("filterMode", (Object)"none");
            this.whitelist = builder.comment("Whitelist Filter").defineList(StrawgolemConfig.FILTER_MODE_WHITELIST, Collections.emptyList(), o -> o instanceof String);
            this.blacklist = builder.comment("Blacklist Filter").defineList(StrawgolemConfig.FILTER_MODE_BLACKLIST, Collections.emptyList(), o -> o instanceof String);
            builder.pop();
            builder.push("Lifespan");
            this.lifespan = builder.comment("Set the lifespan, in tick, of new created straw golems. Set -1 for infinite.").defineInRange("lifespan", 168000, -2, Integer.MAX_VALUE);
            this.heavyPenalty = builder.comment("Enable lifespan penalty for carrying a heavy item").define("penaltyHeavy", true);
            this.rainPenalty = builder.comment("Enable lifespan penalty for being in the rain").define("penaltyRain", true);
            this.waterPenalty = builder.comment("Enable lifespan penalty for being in the water").define("penaltyWater", true);
            builder.pop();
            builder.push("Miscellaneous");
            this.soundsEnabled = builder.comment("Enable/disable golem sounds").define("soundsEnabled", true);
            this.shiverEnabled = builder.comment("Enable/disable golem shivering in cold").define("shiverEnabled", true);
            this.golemInteract = builder.comment("Enable iron golems picking up straw golems occasionally").define("golemInteract", true);
            this.enableHwyla = builder.comment("Enable HWYLA compatibility").define("enableHwyla", true);
            builder.pop();
        }
    }

    public static enum FilterMatch {
        None,
        Mod,
        Exact;

    }
}

