/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.storage;

import com.commodorethrawn.strawgolem.events.CropGrowthHandler;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class StrawgolemSaveData
extends WorldSavedData {
    private static final String WORLD = "world";
    private static final String POS = "pos";

    public StrawgolemSaveData() {
        super("strawgolem");
    }

    public StrawgolemSaveData(String name) {
        super(name);
        this.func_76185_a();
    }

    public static StrawgolemSaveData get(ServerWorld world) {
        DimensionSavedDataManager storage = world.func_217481_x();
        return (StrawgolemSaveData)storage.func_215752_a(StrawgolemSaveData::new, "strawgolem");
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT listTag = nbt.func_150295_c("listTag", 10);
        for (INBT tag : listTag) {
            RegistryKey dim;
            CompoundNBT entryTag = (CompoundNBT)tag;
            BlockPos pos = null;
            ServerWorld world = null;
            if (entryTag.func_74781_a(POS) != null) {
                pos = NBTUtil.func_186861_c((CompoundNBT)entryTag.func_74775_l(POS));
            }
            if (entryTag.func_74781_a(WORLD) != null && (dim = (RegistryKey)DimensionType.func_236025_a_((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)entryTag.func_74781_a(WORLD))).result().orElseThrow(() -> new IllegalArgumentException("Invalid map dimension: " + entryTag.func_74781_a(WORLD)))) != null) {
                world = ServerLifecycleHooks.getCurrentServer().func_71218_a(dim);
            }
            if (world == null || pos == null) continue;
            CropGrowthHandler.scheduleCrop(world, pos, 3);
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        Iterator<CropGrowthHandler.CropQueueEntry> cropIterator = CropGrowthHandler.getCrops();
        ListNBT listTag = new ListNBT();
        while (cropIterator.hasNext()) {
            CompoundNBT entryTag = new CompoundNBT();
            CropGrowthHandler.CropQueueEntry entry = cropIterator.next();
            entryTag.func_218657_a(POS, (INBT)NBTUtil.func_186859_a((BlockPos)entry.getPos()));
            ResourceLocation.field_240908_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)entry.getWorld().func_234923_W_().func_240901_a_()).result().ifPresent(dim -> entryTag.func_218657_a(WORLD, dim));
            listTag.add((Object)entryTag);
        }
        compound.func_218657_a("listTag", (INBT)listTag);
        return compound;
    }
}

