/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.streak.common.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fml.config.ModConfig;

public class Config
extends ConfigBase {
    @CategoryDivider(name="clientOnly")
    @Prop(min=5.0)
    public int streakTime = 100;
    @Prop(min=0.0, max=100.0)
    public int streakOpacity = 100;
    @Prop(min=0.0)
    public int sprintTrail = 6;
    @Prop
    public boolean renderInFirstPerson = false;
    @Prop(validator="attachValidator")
    public List<String> attachTo = new ArrayList<String>(){
        {
            this.add("minecraft:player");
        }
    };
    @Prop(validator="flavorValidator")
    public List<String> setFlavors = new ArrayList<String>();
    public HashSet<ResourceLocation> attachments = new HashSet();
    public HashMap<String, String> setFlavourMap = new HashMap();

    public boolean attachValidator(Object o) {
        if (o instanceof String) {
            try {
                new ResourceLocation((String)o);
                return true;
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean flavorValidator(Object o) {
        return o instanceof String && ((String)o).split(":").length == 2;
    }

    @Nonnull
    public String getModId() {
        return "streak";
    }

    @Nonnull
    public String getConfigName() {
        return "Streak";
    }

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }

    public void onConfigLoaded() {
        Minecraft.func_71410_x().execute(this::parseConfig);
    }

    public void parseConfig() {
        this.attachments.clear();
        for (String s : this.attachTo) {
            this.attachments.add(new ResourceLocation(s));
        }
        this.setFlavourMap.clear();
        for (String s : this.setFlavors) {
            String[] split = s.split(":");
            this.setFlavourMap.put(split[0], split[1].toLowerCase());
        }
    }
}

