/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.streak.common.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.client.tracker.entity.EntityTracker;
import me.ichun.mods.ichunutil.client.tracker.tag.Tag;
import me.ichun.mods.streak.common.Streak;
import me.ichun.mods.streak.common.core.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class StreakTag
implements Tag {
    @Nonnull
    public EventHandler.FlavourInfo flavour;
    public HashMap<EntityTracker.EntityInfo, StreakInfo> texUs = new HashMap();

    public int maxTracks() {
        return Math.max(Streak.config.streakTime, Streak.config.sprintTrail);
    }

    public int maxDeathPersist() {
        return Math.max(Streak.config.streakTime, Streak.config.sprintTrail);
    }

    public void init(EntityTracker tracker) {
        this.flavour = Streak.eventHandler.getFlavourFor(tracker.parent);
    }

    public void tick(EntityTracker tracker) {
    }

    public void addInfo(EntityTracker tracker, EntityTracker.EntityInfo info) {
        if (this.texUs.isEmpty()) {
            this.texUs.put(info, this.createFor((LivingEntity)tracker.parent, 0.0f));
        } else {
            EntityTracker.EntityInfo lastInfo = (EntityTracker.EntityInfo)tracker.trackedInfo.get(1);
            double x = lastInfo.posX - info.posX;
            double z = lastInfo.posZ - info.posZ;
            double dist = Math.sqrt(x * x + z * z);
            double minHeight = Math.min(lastInfo.height, info.height);
            this.texUs.put(info, this.createFor((LivingEntity)tracker.parent, this.texUs.getOrDefault((Object)lastInfo, (StreakInfo)this.createFor((LivingEntity)((LivingEntity)tracker.parent), (float)0.0f)).texU + (float)(dist / minHeight)));
        }
    }

    public StreakInfo createFor(LivingEntity entityIn, float texU) {
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (entityIn.func_70089_S()) {
            f8 = entityIn.field_70721_aZ;
            f5 = entityIn.field_184619_aG;
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        return new StreakInfo(texU, entityIn.func_70051_ag() && entityIn.func_70089_S(), entityIn.func_70678_g(1.0f), f5, f8, entityIn.field_70173_aa, entityIn.field_70761_aq, entityIn.field_70759_as - entityIn.field_70761_aq, entityIn.field_70125_A);
    }

    public void removeInfo(EntityTracker tracker, EntityTracker.EntityInfo info) {
        this.texUs.remove(info);
    }

    public boolean ignoreFrustumCheck() {
        return true;
    }

    public void render(EntityTracker tracker, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean firstPerson;
        if (tracker.trackedInfo.size() <= 1) {
            return;
        }
        boolean bl = firstPerson = tracker.parent == Minecraft.func_71410_x().func_175606_aa() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        if (firstPerson && !Streak.config.renderInFirstPerson) {
            return;
        }
        matrixStackIn.func_227860_a_();
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)tracker.parent.field_70142_S, (double)tracker.parent.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)tracker.parent.field_70137_T, (double)tracker.parent.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)tracker.parent.field_70136_U, (double)tracker.parent.func_226281_cx_());
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        float opacity = (float)Streak.config.streakOpacity / 100.0f;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.flavour.getResourceLocation()));
        for (int i = Math.min(Streak.config.streakTime, tracker.trackedInfo.size()) - 1 - tracker.timeAfterDeath; i >= 1; --i) {
            float u1;
            EntityTracker.EntityInfo info = (EntityTracker.EntityInfo)tracker.trackedInfo.get(i);
            StreakInfo si = this.texUs.get(info);
            if (si == null) continue;
            float u = si.texU;
            EntityTracker.EntityInfo nextInfo = (EntityTracker.EntityInfo)tracker.trackedInfo.get(i - 1);
            StreakInfo si1 = this.texUs.get(nextInfo);
            if (si1 == null || u == (u1 = si1.texU) || info.invisible && nextInfo.invisible) continue;
            float x = (float)(info.posX - d0);
            float y = (float)(info.posY - d1);
            float z = (float)(info.posZ - d2);
            float x1 = (float)(nextInfo.posX - d0);
            float y1 = (float)(nextInfo.posY - d1);
            float z1 = (float)(nextInfo.posZ - d2);
            int alpha = 255;
            int alpha1 = 255;
            int trailingAlpha = Math.min(Streak.config.streakTime, tracker.trackedInfo.size()) - 21 - tracker.timeAfterDeath;
            if (info.invisible) {
                alpha = 0;
            }
            if (i < 5) {
                if (tracker.parent.func_70089_S()) {
                    alpha1 = (int)(((float)i + partialTicks) / 5.0f * 255.0f);
                    alpha = (int)(((float)i + partialTicks - 1.0f) / 5.0f * 255.0f);
                } else {
                    alpha1 = (int)((float)i / 5.0f * 255.0f);
                    alpha = (int)((float)(i - 1) / 5.0f * 255.0f);
                }
            }
            if (i > trailingAlpha) {
                alpha = (int)((1.0f - ((float)i + partialTicks - (float)trailingAlpha) / 20.0f) * (float)alpha);
                alpha1 = (int)((1.0f - ((float)i + partialTicks - 1.0f - (float)trailingAlpha) / 20.0f) * (float)alpha1);
            }
            if (nextInfo.invisible) {
                alpha1 = 0;
            }
            alpha = (int)((float)alpha * opacity);
            alpha1 = (int)((float)alpha1 * opacity);
            ivertexbuilder.func_227888_a_(matrix4f, x, y, z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(u, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, x, y + info.height, z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(u, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, x1, y1 + info.height, z1).func_225586_a_(255, 255, 255, alpha1).func_225583_a_(u1, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, x1, y1, z1).func_225586_a_(255, 255, 255, alpha1).func_225583_a_(u1, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
        }
        LivingRenderer renderer = null;
        EntityRenderer entRend = Minecraft.func_71410_x().func_175598_ae().func_78713_a(tracker.parent);
        if (entRend instanceof LivingRenderer) {
            renderer = (LivingRenderer)entRend;
        }
        if (renderer != null) {
            ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)renderer.func_110775_a(tracker.parent)));
            for (int i = Math.min(Streak.config.sprintTrail, tracker.trackedInfo.size()) - 1 - tracker.timeAfterDeath; i >= 1; --i) {
                EntityTracker.EntityInfo info = (EntityTracker.EntityInfo)tracker.trackedInfo.get(i);
                StreakInfo si = this.texUs.get(info);
                if (si == null || !si.sprint) continue;
                float x = (float)(info.posX - d0);
                float y = (float)(info.posY - d1);
                float z = (float)(info.posZ - d2);
                EntityModel model = renderer.func_217764_d();
                model.field_217112_c = si.swingProg;
                model.func_212843_a_(tracker.parent, si.swing, si.revSwing, 1.0f);
                model.func_225597_a_(tracker.parent, si.swing, si.revSwing, si.age, si.yaw, si.pitch);
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)x, (double)y, (double)z);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - si.yawOffset));
                matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
                RenderHelper.invokePreRenderCallback((LivingRenderer)renderer, (LivingEntity)((LivingEntity)tracker.parent), (MatrixStack)matrixStackIn, (float)partialTicks);
                matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
                model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, ((float)(Streak.config.sprintTrail + 1) - ((float)i + partialTicks)) / (float)Streak.config.sprintTrail * 1.0f);
                matrixStackIn.func_227865_b_();
            }
        }
        matrixStackIn.func_227865_b_();
    }

    public static class StreakInfo {
        public final float texU;
        public final boolean sprint;
        public final float swingProg;
        public final float swing;
        public final float revSwing;
        public final float age;
        public final float yawOffset;
        public final float yaw;
        public final float pitch;

        public StreakInfo(float texU, boolean sprint, float swingProg, float swing, float revSwing, float age, float yawOffset, float yaw, float pitch) {
            this.texU = texU;
            this.sprint = sprint;
            this.swingProg = swingProg;
            this.swing = swing;
            this.revSwing = revSwing;
            this.age = age;
            this.yawOffset = yawOffset;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

