/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.streak.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.ichun.mods.ichunutil.client.core.EventHandlerClient;
import me.ichun.mods.ichunutil.client.tracker.ClientEntityTracker;
import me.ichun.mods.streak.common.core.Config;
import me.ichun.mods.streak.common.core.EventHandler;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="streak")
public class Streak {
    public static final String MOD_ID = "streak";
    public static final String MOD_NAME = "Streak";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Config config;
    public static EventHandler eventHandler;

    public Streak() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            config = (Config)new Config().init();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
            ClientEntityTracker.init((IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
            eventHandler = new EventHandler();
            MinecraftForge.EVENT_BUS.register((Object)eventHandler);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> EventHandlerClient::getConfigGui);
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.log(Level.ERROR, "You are loading Streak on a server. Streak is a client only mod!"));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        this.unpackFlavours();
    }

    private void unpackFlavours() {
        File streakDir = new File(FMLPaths.MODSDIR.get().toFile(), "/Streak Flavours");
        if (!streakDir.exists() && streakDir.mkdirs()) {
            try (InputStream in = Streak.class.getResourceAsStream("/flavours.zip");
                 ZipInputStream zipStream = new ZipInputStream(in);){
                ZipEntry entry = null;
                int extractCount = 0;
                while ((entry = zipStream.getNextEntry()) != null) {
                    int len;
                    File file = new File(streakDir, entry.getName());
                    if (file.exists() && file.length() > 3L) continue;
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((len = zipStream.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    ++extractCount;
                }
                if (extractCount > 0) {
                    LOGGER.info("Extracted flavours from mod zip: {}", (Object)extractCount);
                }
            }
            catch (IOException | NullPointerException e) {
                LOGGER.warn("Failed to extract streak flavours from mod jar");
                e.printStackTrace();
            }
        }
        if (streakDir.exists()) {
            for (File file : streakDir.listFiles()) {
                if (!file.getName().endsWith(".png")) continue;
                try {
                    NativeImage img = NativeImage.func_195713_a((InputStream)new FileInputStream(file));
                    Streak.eventHandler.flavours.add(new EventHandler.FlavourInfo(file.getName().substring(0, file.getName().length() - 4).toLowerCase(), img));
                }
                catch (IOException e) {
                    LOGGER.error("Error reading file: " + file.getName());
                    e.printStackTrace();
                }
            }
        }
    }
}

