/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.streak.common.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import us.ichun.mods.ichunutil.common.iChunUtil;
import us.ichun.mods.ichunutil.common.tracker.EntityInfo;
import us.ichun.mods.ichunutil.common.tracker.IAdditionalTrackerInfo;
import us.ichun.mods.streak.common.Streak;
import us.ichun.mods.streak.common.core.TextureTracker;
import us.ichun.mods.streak.common.entity.EntityStreak;

public class TickHandlerClient {
    public float renderTick;
    public WorldClient worldInstance;
    public HashMap<String, EntityStreak> streaks = new HashMap();

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.renderTick = event.renderTickTime;
            Iterator<Map.Entry<String, EntityStreak>> iterator = this.streaks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, EntityStreak> e = iterator.next();
                if (e.getValue().parent == null) continue;
                EntityStreak streak = e.getValue();
                if (e.getValue().parent.field_70128_L) {
                    streak.func_70106_y();
                    iterator.remove();
                    continue;
                }
                this.updatePos(streak, streak.parent);
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.worldInstance != world) {
                this.worldInstance = world;
                this.streaks.clear();
            }
            Iterator<Map.Entry<String, EntityStreak>> ite = this.streaks.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, EntityStreak> e = ite.next();
                if (e.getValue().field_70170_p.field_73011_w.func_177502_q() == world.field_73011_w.func_177502_q() && world.func_72820_D() - e.getValue().lastUpdate <= 10L) continue;
                e.getValue().func_70106_y();
                ite.remove();
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            ArrayList loc;
            EntityPlayer player = event.player;
            if (player.field_70170_p.func_72924_a(player.func_70005_c_()) != player) {
                return;
            }
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityStreak hat = this.streaks.get(player.func_70005_c_());
            if (hat == null || hat.field_70128_L) {
                if (player.func_70005_c_().equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                    for (Map.Entry<String, EntityStreak> e : this.streaks.entrySet()) {
                        e.getValue().func_70106_y();
                    }
                }
                hat = new EntityStreak((World)world, (EntityLivingBase)player);
                this.streaks.put(player.func_70005_c_(), hat);
                world.func_72838_d((Entity)hat);
            }
            if ((loc = iChunUtil.proxy.tickHandlerClient.getOrRegisterEntityTracker((EntityLivingBase)player, Streak.config.streakTime, TextureTracker.class, true)).size() > 1) {
                EntityInfo newest = (EntityInfo)loc.get(1);
                EntityInfo newer = (EntityInfo)loc.get(0);
                double distX = newest.posX - newer.posX;
                double distZ = newest.posZ - newer.posZ;
                IAdditionalTrackerInfo tracker1 = newest.getTracker(TextureTracker.class);
                IAdditionalTrackerInfo tracker2 = newer.getTracker(TextureTracker.class);
                if (tracker1 != null && tracker2 != null) {
                    ((TextureTracker)tracker2).startU = ((TextureTracker)tracker1).startU + Math.sqrt(distX * distX + distZ * distZ) / (double)newest.height;
                    while (((TextureTracker)tracker2).startU > 1.0) {
                        ((TextureTracker)tracker2).startU -= 1.0;
                    }
                }
            }
        }
    }

    public void updatePos(EntityStreak streak, EntityLivingBase parent) {
        streak.field_70142_S = streak.parent.field_70142_S;
        streak.field_70137_T = streak.parent.field_70137_T;
        streak.field_70136_U = streak.parent.field_70136_U;
        streak.field_70169_q = streak.parent.field_70169_q;
        streak.field_70167_r = streak.parent.field_70167_r;
        streak.field_70166_s = streak.parent.field_70166_s;
        streak.field_70165_t = streak.parent.field_70165_t;
        streak.field_70163_u = streak.parent.field_70163_u;
        streak.field_70161_v = streak.parent.field_70161_v;
    }
}

